/*
 * Copyright (c) 2014 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.aggregates.aggregation

import org.molap.aggregates.cube.Group
import org.molap.aggregates.cuboid.Cuboid
import kotlin.reflect.KClass

interface Aggregation<T> {
    fun `as`(name: String?): Aggregation<*>?
    val name: String?
    val type: KClass<Any>
    fun compute(cuboid: Cuboid?, group: Group?): T?

    /**
     * Creates a new aggregation method that adds the value of the specified aggregation to this aggregation.
     *
     * @param aggregation the aggregation method whose value is to add
     *
     * @return a new aggregation method
     */
    fun add(aggregation: Aggregation<*>?): Aggregation<*>?

    /**
     * Creates a new aggregation method that subtracts the value of the specified aggregation to this aggregation.
     *
     * @param aggregation the aggregation method whose value is to subtract
     *
     * @return a new aggregation method
     */
    fun substract(aggregation: Aggregation<*>?): Aggregation<*>?

    /**
     * Creates a new aggregation method that multiplies the value of the specified aggregation to this aggregation.
     *
     * @param aggregation the aggregation method whose value is to multiply
     *
     * @return a new aggregation method
     */
    fun multiply(aggregation: Aggregation<*>?): Aggregation<*>?

    /**
     * Creates a new aggregation method that divides the value of the specified aggregation to this aggregation.
     *
     * @param aggregation the aggregation method whose value is to divide
     *
     * @return a new aggregation method
     */
    fun divide(aggregation: Aggregation<*>?): Aggregation<*>?

    /**
     * Creates a new aggregation method that returns the minimum the specified aggregation to this aggregation.
     *
     * @param aggregation the aggregation method whose value is to minimize
     *
     * @return a new aggregation method
     */
    fun min(aggregation: Aggregation<*>?): Aggregation<*>?

    /**
     * Creates a new aggregation method that returns the maximum the specified aggregation to this aggregation.
     *
     * @param aggregation the aggregation method whose value is to maximize
     *
     * @return a new aggregation method
     */
    fun max(aggregation: Aggregation<*>?): Aggregation<*>?
}