package org.molap.dataframe

fun dataFrameOf(header: Iterable<String>) = InplaceDataFrameBuilder(header.toList())

class InplaceDataFrameBuilder(private val header: List<String>) {


    operator fun invoke(args: Iterable<Any?>): DataFrame<Int,String,Any> {
        return invoke(*args.toList().toTypedArray())
    }


    operator fun invoke(args: Sequence<Any?>): DataFrame<Int,String,Any> {
        return invoke(*args.toList().toTypedArray())
    }

    operator fun invoke(vararg tblData: Any?): DataFrame<Int,String,Any> {
        //        if(tblData.first() is Iterable<Any?>) {
        //            tblData = tblData.first() as Iterable<Any?>
        //        }

        // is the data vector compatible with the header dimension?
        require(header.size > 0 && tblData.size.rem(header.size) == 0) {
            "data dimension ${header.size} is not compatible with length of data vector ${tblData.size}"
        }

        // 1) break into columns
        val rawColumns: List<List<Any?>> = tblData.toList()
            .mapIndexed { i, any -> i.rem(header.size) to any }
            .groupBy { it.first }.values.map {
            it.map { it.second }
        }


        // 2) infer column type by peeking into column data
        val tableColumns = header.zip(rawColumns).map {
//            handleListErasure(it.first, it.second)
        }

//        require(tableColumns.map { it.length }.distinct().size == 1) {
//            "Provided data does not coerce to tabular shape"
//        }

        // 3) bind into data-frame
//        return SimpleDataFrame(tableColumns)
        return TODO()
    }


    //    operator fun invoke(values: List<Any?>): DataFrame {
    //        return invoke(values.toTypedArray())
    //    }

}