package org.molap.series

import org.molap.index.IntegerRangeUniqueIndex
import org.molap.index.UniqueIndex
import kotlin.reflect.KClass

class DefaultSeries<V> : AbstractSeries<Int, V>, MutableSeries<Int, V> {
    override val name: Any?
    private val values: Array<V>
    private val index: UniqueIndex<Int>

    constructor(values: Array<V>) {
        name = null
        this.values = values
        index = IntegerRangeUniqueIndex(0, values.size - 1)
    }

    constructor(name: Any, values: Array<V>) {
        this.name = name
        this.values = values
        index = IntegerRangeUniqueIndex(0, values.size - 1)
    }

    private constructor(values: Array<V>, index: UniqueIndex<Int>) {
        name = null
        this.values = values
        this.index = index
    }

    //    override val type: KClass<out Any>
//        get() = values.component1()!!::class
    override val type: KClass<out Any>
        get() = Any::class

    override fun get(key: Int): V {
        return values[key]
    }

    override fun getKey(i: Int): Int {
        return index.getKey(i)
    }

    override fun size(): Int {
        return index.size
    }

    override fun getAddress(key: Int): Int {
        return index.getAddress(key)
    }

    override operator fun set(key: Int, value: V) {
        values[key] = value
    }

    override fun keys(): Iterable<Int> {
        return index.keys()
    }

//    fun <L> reindex(vararg keys: L?): Series<L?, V?>? {
//        return null
//    }

    fun head(count: Int): Series<Int, V> {
        return reindex(index.head(count))
    }

    fun tail(count: Int): Series<Int, V> {
        return reindex(index.tail(count))
    }

    fun <K> reindex(index: UniqueIndex<K>): Series<K, V> {
        return IndexedSeries<K, V>(name, values, index)
    }
}
