/*
 * Decompiled with CFR 0.152.
 */
package org.molap.aggregates.cube;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.series.Series;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0004\n\u0002\b\u001b\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001@B\u001b\b\u0016\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004B-\b\u0016\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0002\b\u00030\u0003\u0012\u0010\u0010\u0005\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B?\b\u0016\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0002\b\u00030\u0003\u0012\u0010\u0010\u0005\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u0006\u0012\u0010\u0010\b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\t\u00a2\u0006\u0002\u0010\nB\u0005\u00a2\u0006\u0002\u0010\u000bJ\u000e\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u0000J\u0006\u00109\u001a\u000207J\u000e\u0010:\u001a\u0002072\u0006\u0010;\u001a\u00020\u001bJ\u000e\u0010<\u001a\u0002072\u0006\u0010=\u001a\u00020\rJ\b\u0010>\u001a\u00020?H\u0016R\u0013\u0010\f\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u001e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u0013\u0010\u0019\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u000fR\"\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u001b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010\u001f\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u000fR\"\u0010!\u001a\u0004\u0018\u00010\u001b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u001b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001eR\u0013\u0010#\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u000fR\u0013\u0010%\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u000fR\u0013\u0010'\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u000fR\u0013\u0010)\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u000fR$\u0010+\u001a\u0004\u0018\u00010\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\r@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010-\u001a\u0004\b,\u0010\u000fR\u0013\u0010.\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u000fR$\u00100\u001a\u0004\u0018\u00010\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\r@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010-\u001a\u0004\b1\u0010\u000fR\u0013\u00102\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u000fR\u0013\u00104\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b5\u0010\u000f\u00a8\u0006A"}, d2={"Lorg/molap/aggregates/cube/DistributiveStatistics;", "", "series", "Lorg/molap/series/Series;", "(Lorg/molap/series/Series;)V", "keys", "", "(Lorg/molap/series/Series;Ljava/lang/Iterable;)V", "filter", "Lorg/molap/aggregates/cube/DistributiveStatistics$RowFilter;", "(Lorg/molap/series/Series;Ljava/lang/Iterable;Lorg/molap/aggregates/cube/DistributiveStatistics$RowFilter;)V", "()V", "coefficientOfVariance", "", "getCoefficientOfVariance", "()Ljava/lang/Double;", "correctedSumOfSquares", "getCorrectedSumOfSquares", "<set-?>", "", "count", "getCount", "()J", "countOfMissing", "getCountOfMissing", "lowerConfidenceLimit", "getLowerConfidenceLimit", "", "maximum", "getMaximum", "()Ljava/lang/Number;", "mean", "getMean", "minimum", "getMinimum", "probabilityOfGreaterAbsoluteValue", "getProbabilityOfGreaterAbsoluteValue", "range", "getRange", "standardDeviation", "getStandardDeviation", "standardErrorOfMean", "getStandardErrorOfMean", "sum", "getSum", "Ljava/lang/Double;", "tValue", "getTValue", "uncorrectedSumOfSquares", "getUncorrectedSumOfSquares", "upperConfidenceLimit", "getUpperConfidenceLimit", "variance", "getVariance", "add", "", "distributiveStatistics", "addMissing", "addNumber", "value", "addValue", "v", "toString", "", "RowFilter", "molap"})
public final class DistributiveStatistics {
    private long count;
    private long countOfMissing;
    @Nullable
    private Double sum;
    @Nullable
    private Double uncorrectedSumOfSquares;
    @Nullable
    private Number minimum;
    @Nullable
    private Number maximum;

    public final long getCount() {
        return this.count;
    }

    public final long getCountOfMissing() {
        return this.countOfMissing;
    }

    @Nullable
    public final Double getSum() {
        return this.sum;
    }

    @Nullable
    public final Double getUncorrectedSumOfSquares() {
        return this.uncorrectedSumOfSquares;
    }

    @Nullable
    public final Number getMinimum() {
        return this.minimum;
    }

    @Nullable
    public final Number getMaximum() {
        return this.maximum;
    }

    public final void addNumber(@NotNull Number value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        long count = this.count;
        long countOfMissing = this.countOfMissing;
        Double sum = this.sum;
        Double uncorrectedSumOfSquares = this.uncorrectedSumOfSquares;
        Number minimum = this.minimum;
        Number maximum = this.maximum;
        double v = value.doubleValue();
        sum = sum != null ? Double.valueOf(sum + v) : Double.valueOf(v);
        uncorrectedSumOfSquares = uncorrectedSumOfSquares != null ? Double.valueOf(uncorrectedSumOfSquares + v * v) : Double.valueOf(v * v);
        if (minimum == null || v < minimum.doubleValue()) {
            minimum = value;
        }
        if (maximum == null || v > maximum.doubleValue()) {
            maximum = value;
        }
        long l = count;
        this.count = count = l + 1L;
        this.countOfMissing = countOfMissing;
        this.sum = sum;
        this.uncorrectedSumOfSquares = uncorrectedSumOfSquares;
        this.minimum = minimum;
        this.maximum = maximum;
    }

    public final void addMissing() {
        long l = this.countOfMissing;
        this.countOfMissing = l + 1L;
    }

    public final void addValue(double v) {
        long count = this.count;
        long countOfMissing = this.countOfMissing;
        Double sum = this.sum;
        Double uncorrectedSumOfSquares = this.uncorrectedSumOfSquares;
        Number minimum = this.minimum;
        Number maximum = this.maximum;
        sum = sum != null ? Double.valueOf(sum + v) : Double.valueOf(v);
        uncorrectedSumOfSquares = uncorrectedSumOfSquares != null ? Double.valueOf(uncorrectedSumOfSquares + v * v) : Double.valueOf(v * v);
        if (minimum == null || v < minimum.doubleValue()) {
            minimum = v;
        }
        if (maximum == null || v > maximum.doubleValue()) {
            maximum = v;
        }
        long l = count;
        this.count = count = l + 1L;
        this.countOfMissing = countOfMissing;
        this.sum = sum;
        this.uncorrectedSumOfSquares = uncorrectedSumOfSquares;
        this.minimum = minimum;
        this.maximum = maximum;
    }

    public final void add(@NotNull DistributiveStatistics distributiveStatistics) {
        Double otherUncorrectedSumOfSquares;
        Intrinsics.checkNotNullParameter((Object)distributiveStatistics, (String)"distributiveStatistics");
        Double sum = this.sum;
        Double uncorrectedSumOfSquares = this.uncorrectedSumOfSquares;
        Number minimum = this.minimum;
        Number maximum = this.maximum;
        this.count += distributiveStatistics.count;
        this.countOfMissing += distributiveStatistics.countOfMissing;
        Double osum = distributiveStatistics.sum;
        if (osum != null) {
            if (sum != null) {
                sum = sum + osum;
            } else {
                this.sum = osum;
            }
        }
        if ((otherUncorrectedSumOfSquares = distributiveStatistics.uncorrectedSumOfSquares) != null) {
            uncorrectedSumOfSquares = uncorrectedSumOfSquares != null ? Double.valueOf(uncorrectedSumOfSquares + otherUncorrectedSumOfSquares) : otherUncorrectedSumOfSquares;
        }
        Number otherMinimum = distributiveStatistics.minimum;
        if (minimum == null || otherMinimum != null && otherMinimum.doubleValue() < minimum.doubleValue()) {
            minimum = otherMinimum;
        }
        Number otherMaximum = distributiveStatistics.maximum;
        if (maximum == null || otherMaximum != null && otherMaximum.doubleValue() > maximum.doubleValue()) {
            maximum = otherMaximum;
        }
        this.sum = sum;
        this.uncorrectedSumOfSquares = uncorrectedSumOfSquares;
        this.minimum = minimum;
        this.maximum = maximum;
    }

    @Nullable
    public final Double getMean() {
        Double d;
        if (this.count > 0L) {
            Double d2 = this.sum;
            Intrinsics.checkNotNull((Object)d2);
            d = d2 / (double)this.count;
        } else {
            d = null;
        }
        return d;
    }

    @Nullable
    public final Double getRange() {
        Number minimum = this.minimum;
        Number maximum = this.maximum;
        if (maximum != null && minimum != null) {
            return maximum.doubleValue() - minimum.doubleValue();
        }
        return null;
    }

    @Nullable
    public final Double getCorrectedSumOfSquares() {
        return null;
    }

    @Nullable
    public final Double getVariance() {
        Double d;
        Double mean = this.getMean();
        if (mean != null) {
            Double d2 = this.uncorrectedSumOfSquares;
            Intrinsics.checkNotNull((Object)d2);
            d = d2 / (double)this.count - mean * mean;
        } else {
            d = null;
        }
        return d;
    }

    @Nullable
    public final Double getStandardDeviation() {
        Double d;
        Double variance = this.getVariance();
        if (variance != null) {
            double d2 = variance;
            boolean bl = false;
            d = Math.sqrt(d2);
        } else {
            d = null;
        }
        return d;
    }

    @Nullable
    public final Double getStandardErrorOfMean() {
        return null;
    }

    @Nullable
    public final Double getCoefficientOfVariance() {
        return null;
    }

    @Nullable
    public final Double getTValue() {
        return null;
    }

    @Nullable
    public final Double getProbabilityOfGreaterAbsoluteValue() {
        return null;
    }

    @Nullable
    public final Double getLowerConfidenceLimit() {
        return null;
    }

    @Nullable
    public final Double getUpperConfidenceLimit() {
        return null;
    }

    @NotNull
    public String toString() {
        return "DistributiveStatistics{count=" + this.count + ", countOfMissing=" + this.countOfMissing + ", sum=" + this.sum + ", uncorrectedSumOfSquares=" + this.uncorrectedSumOfSquares + ", minimum=" + this.minimum + ", maximum=" + this.maximum + ", mean=" + this.getMean() + ", variance=" + this.getVariance() + ", stdDev=" + this.getStandardDeviation() + '}';
    }

    public DistributiveStatistics() {
    }

    public DistributiveStatistics(@NotNull Series<Object, ?> series) {
        Intrinsics.checkNotNullParameter(series, (String)"series");
        this(series, series.keys());
    }

    public DistributiveStatistics(@NotNull Series<Object, ?> series, @Nullable Iterable<? extends Object> keys2) {
        Intrinsics.checkNotNullParameter(series, (String)"series");
        this(series, keys2, null);
    }

    public DistributiveStatistics(@NotNull Series<Object, ?> series, @Nullable Iterable<? extends Object> keys2, @Nullable RowFilter<Object> filter) {
        Intrinsics.checkNotNullParameter(series, (String)"series");
        this();
        Iterable<? extends Object> iterable = keys2;
        Intrinsics.checkNotNull(iterable);
        for (Object object : iterable) {
            if (filter != null && !filter.accept(object)) continue;
            Object value = series.get(object);
            if (value != null) {
                if (!(value instanceof Number)) continue;
                this.addNumber((Number)value);
                continue;
            }
            this.addMissing();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\bf\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/molap/aggregates/cube/DistributiveStatistics$RowFilter;", "R", "", "accept", "", "row", "(Ljava/lang/Object;)Z", "molap"})
    public static interface RowFilter<R> {
        public boolean accept(R var1);
    }
}

