/*
 * Decompiled with CFR 0.152.
 */
package org.molap.aggregates.cube;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.aggregates.cube.KthSelector;
import org.molap.series.Series;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u0000 82\n\u0012\u0006\u0012\u0004\u0018\u00010\u00000\u0001:\u0006789:;<B\u001b\b\u0016\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005B'\b\u0016\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u0012\u0010\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\bJ\u0013\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010\u0000H\u0096\u0002J\u0015\u0010+\u001a\u0004\u0018\u00010\u00132\u0006\u0010,\u001a\u00020\u0013\u00a2\u0006\u0002\u0010-J\u001d\u0010+\u001a\u0004\u0018\u00010\u00132\u0006\u0010.\u001a\u00020/2\u0006\u0010,\u001a\u00020\u0013\u00a2\u0006\u0002\u00100J\u0010\u00101\u001a\u0004\u0018\u00010\u00042\u0006\u00102\u001a\u00020\u0013J\u0015\u00103\u001a\u0004\u0018\u00010\u00132\u0006\u00104\u001a\u00020\u0013\u00a2\u0006\u0002\u0010-J\b\u00105\u001a\u000206H\u0016R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0011R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0011R\u001c\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001d\u001a\u0004\u0018\u00010\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0015R$\u0010\u001f\u001a\u0004\u0018\u00010\u00132\b\u0010\t\u001a\u0004\u0018\u00010\u0013@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010!\u001a\u0004\b \u0010\u0015R$\u0010\"\u001a\u0004\u0018\u00010\u00132\b\u0010\t\u001a\u0004\u0018\u00010\u0013@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010!\u001a\u0004\b#\u0010\u0015R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000f0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010&\u001a\u0004\u0018\u00010\u00138F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0015\u00a8\u0006="}, d2={"Lorg/molap/aggregates/cube/UnivariateStatistics;", "", "column", "Lorg/molap/series/Series;", "", "(Lorg/molap/series/Series;)V", "rows", "", "(Ljava/lang/Iterable;Lorg/molap/series/Series;)V", "<set-?>", "", "count", "getCount", "()J", "maximum", "", "getMaximum", "()Ljava/lang/Number;", "mean", "", "getMean", "()Ljava/lang/Double;", "median", "getMedian", "minimum", "getMinimum", "statistics", "", "Lorg/molap/aggregates/cube/UnivariateStatistics$Statistics;", "stdDev", "getStdDev", "sum", "getSum", "Ljava/lang/Double;", "uncorrectedSumOfSquares", "getUncorrectedSumOfSquares", "values", "", "variance", "getVariance", "compareTo", "", "o", "getPercentile", "p", "(D)Ljava/lang/Double;", "type", "Lorg/molap/aggregates/cube/UnivariateStatistics$EstimationType;", "(Lorg/molap/aggregates/cube/UnivariateStatistics$EstimationType;D)Ljava/lang/Double;", "getSigma", "sigma", "toPercentile", "value", "toString", "", "AbstractEstimationFunction", "Companion", "EstimationFunction", "EstimationType", "NumberComparator", "Statistics", "molap"})
public final class UnivariateStatistics
implements Comparable<UnivariateStatistics> {
    private final Map<Statistics, Double> statistics;
    private final List<Number> values;
    @Nullable
    private Double sum;
    @Nullable
    private Double uncorrectedSumOfSquares;
    private long count;
    private static final Comparator<Number> numberComparator;
    @NotNull
    public static final Companion Companion;

    @Nullable
    public final Double getSum() {
        return this.sum;
    }

    @Nullable
    public final Double getUncorrectedSumOfSquares() {
        return this.uncorrectedSumOfSquares;
    }

    public final long getCount() {
        return this.count;
    }

    @Nullable
    public final Number getMinimum() {
        return this.values.size() > 0 ? (Number)this.values.get(0) : (Number)null;
    }

    @Nullable
    public final Number getMaximum() {
        return this.values.size() > 0 ? (Number)this.values.get(this.values.size() - 1) : (Number)null;
    }

    @Nullable
    public final Double getMean() {
        Double d;
        if (this.count > 0L) {
            Double d2 = this.sum;
            Intrinsics.checkNotNull((Object)d2);
            d = d2 / (double)this.count;
        } else {
            d = null;
        }
        return d;
    }

    @Nullable
    public final Double getVariance() {
        Double d;
        Double mean = this.getMean();
        if (mean != null) {
            Double d2 = this.uncorrectedSumOfSquares;
            Intrinsics.checkNotNull((Object)d2);
            d = d2 / (double)this.count - mean * mean;
        } else {
            d = null;
        }
        return d;
    }

    @Nullable
    public final Double getStdDev() {
        Double d;
        Double variance = this.getVariance();
        if (variance != null) {
            double d2 = variance;
            boolean bl = false;
            d = Math.sqrt(d2);
        } else {
            d = null;
        }
        return d;
    }

    @Nullable
    public final Object getSigma(double sigma) {
        Double stdDev;
        Double mean = this.getMean();
        return mean != null ? ((stdDev = this.getStdDev()) != null ? Double.valueOf(mean + sigma * stdDev) : null) : null;
    }

    @Nullable
    public final Number getMedian() {
        return this.getPercentile(50.0);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Double getPercentile(@NotNull EstimationType type, double p) {
        Double d;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        int n = this.values.size();
        if (n > 0) {
            double[] arr = new double[n];
            int n2 = 0;
            int n3 = ((Collection)this.values).size();
            while (n2 < n3) {
                void i;
                Number number = this.values.get((int)i);
                arr[i] = number.doubleValue();
                ++i;
            }
            d = type.evaluate(arr, p, new KthSelector());
        } else {
            d = null;
        }
        return d;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Double toPercentile(double value) {
        Double d;
        int n = this.values.size();
        if (n > 1) {
            double d2;
            double mid;
            Double percentileValue = this.getPercentile(0.0);
            int lowerPercentile = 0;
            int n2 = 0;
            int n3 = 100;
            while (n2 <= n3) {
                void p;
                Double d3 = percentileValue = this.getPercentile((double)p);
                Intrinsics.checkNotNull((Object)d3);
                if (value <= d3) {
                    lowerPercentile = p;
                    break;
                }
                ++p;
            }
            int upperPercentile = lowerPercentile;
            n3 = lowerPercentile + 1;
            int n4 = 100;
            while (n3 <= n4) {
                void p;
                Double d4 = this.getPercentile((double)p);
                Intrinsics.checkNotNull((Object)d4);
                double d5 = d4;
                Double d6 = percentileValue;
                Intrinsics.checkNotNull((Object)d6);
                if (d5 != d6) break;
                upperPercentile = p++;
            }
            if ((mid = (double)(lowerPercentile + upperPercentile) / 2.0) > (double)50) {
                boolean bl = false;
                d2 = Math.ceil(mid);
            } else {
                boolean bl = false;
                d2 = Math.floor(mid);
            }
            d = d2;
        } else {
            d = n > 0 ? Double.valueOf(50.0) : null;
        }
        return d;
    }

    @Nullable
    public final Double getPercentile(double p) {
        return this.getPercentile(EstimationType.R_7, p);
    }

    @Override
    public int compareTo(@Nullable UnivariateStatistics o) {
        int n;
        if (o != null && this.getMean() != null) {
            Double oMean = o.getMean();
            if (oMean != null) {
                Double d = this.getMean();
                Intrinsics.checkNotNull((Object)d);
                n = Double.compare(d, oMean);
            } else {
                n = 1;
            }
        } else {
            n = 1;
        }
        return n;
    }

    @NotNull
    public String toString() {
        return "UnivariateStatistics{count=" + this.count + ", min=" + this.getMinimum() + ", median=" + this.getMedian() + ", mean=" + this.getMean() + ", max=" + this.getMaximum() + '}';
    }

    public UnivariateStatistics(@NotNull Series<Object, Object> column) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        this.values = new ArrayList();
        Double sum = null;
        Double uncorrectedSumOfSquares = null;
        Iterable<Object> iterable = column.keys();
        Intrinsics.checkNotNull(iterable);
        for (Object row : iterable) {
            double v;
            Object value = column.get(row);
            if (value == null || !(value instanceof Number)) continue;
            Number number = (Number)value;
            double d = v = number.doubleValue();
            boolean bl = false;
            if (Double.isInfinite(d)) continue;
            d = v;
            bl = false;
            if (Double.isNaN(d)) continue;
            this.values.add(number);
            sum = sum != null ? Double.valueOf(sum + number.doubleValue()) : Double.valueOf(number.doubleValue());
            uncorrectedSumOfSquares = uncorrectedSumOfSquares != null ? Double.valueOf(uncorrectedSumOfSquares + v * v) : Double.valueOf(v * v);
            long l = this.count;
            this.count = l + 1L;
        }
        this.sum = sum;
        this.uncorrectedSumOfSquares = uncorrectedSumOfSquares;
        CollectionsKt.sortWith(this.values, numberComparator);
    }

    public UnivariateStatistics(@NotNull Iterable<? extends Object> rows, @NotNull Series<Object, ?> column) {
        Intrinsics.checkNotNullParameter(rows, (String)"rows");
        Intrinsics.checkNotNullParameter(column, (String)"column");
        this.values = new ArrayList();
        Double sum = null;
        Double uncorrectedSumOfSquares = null;
        for (Object object : rows) {
            double v;
            Object value = column.get(object);
            if (value == null || !(value instanceof Number)) continue;
            Object number = value;
            double d = v = ((Number)number).doubleValue();
            boolean bl = false;
            if (Double.isInfinite(d)) continue;
            d = v;
            bl = false;
            if (Double.isNaN(d)) continue;
            this.values.add((Number)number);
            sum = sum != null ? Double.valueOf(sum + ((Number)number).doubleValue()) : Double.valueOf(((Number)number).doubleValue());
            uncorrectedSumOfSquares = uncorrectedSumOfSquares != null ? Double.valueOf(uncorrectedSumOfSquares + v * v) : Double.valueOf(v * v);
            long l = this.count;
            this.count = l + 1L;
        }
        this.sum = sum;
        this.uncorrectedSumOfSquares = uncorrectedSumOfSquares;
        CollectionsKt.sortWith(this.values, numberComparator);
    }

    static {
        Companion = new Companion(null);
        numberComparator = new Comparator<Number>(){

            public int compare(@NotNull Number o1, @NotNull Number o2) {
                Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
                return Double.compare(o1.doubleValue(), o2.doubleValue());
            }
        };
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/molap/aggregates/cube/UnivariateStatistics$Statistics;", "", "(Ljava/lang/String;I)V", "Min", "Max", "Mean", "Median", "molap"})
    private static final class Statistics
    extends Enum<Statistics> {
        public static final /* enum */ Statistics Min;
        public static final /* enum */ Statistics Max;
        public static final /* enum */ Statistics Mean;
        public static final /* enum */ Statistics Median;
        private static final /* synthetic */ Statistics[] $VALUES;

        static {
            Statistics[] statisticsArray = new Statistics[4];
            Statistics[] statisticsArray2 = statisticsArray;
            statisticsArray[0] = Min = new Statistics();
            statisticsArray[1] = Max = new Statistics();
            statisticsArray[2] = Mean = new Statistics();
            statisticsArray[3] = Median = new Statistics();
            $VALUES = statisticsArray;
        }

        public static Statistics[] values() {
            return (Statistics[])$VALUES.clone();
        }

        public static Statistics valueOf(String string) {
            return Enum.valueOf(Statistics.class, string);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001:\n!\"#$%&'()*B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J2\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0004J\u001e\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013J*\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0004J\u0018\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0004R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bj\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b \u00a8\u0006+"}, d2={"Lorg/molap/aggregates/cube/UnivariateStatistics$EstimationType;", "", "longName", "", "func", "Lorg/molap/aggregates/cube/UnivariateStatistics$EstimationFunction;", "(Ljava/lang/String;ILjava/lang/String;Lorg/molap/aggregates/cube/UnivariateStatistics$EstimationFunction;)V", "getLongName", "()Ljava/lang/String;", "estimate", "", "work", "", "pivotsHeap", "", "pos", "length", "", "selector", "Lorg/molap/aggregates/cube/KthSelector;", "evaluate", "p", "index", "LEGACY", "R_1", "R_2", "R_3", "R_4", "R_5", "R_6", "R_7", "R_8", "R_9", "LegacyEstimationFunction", "R1EstimationFunction", "R2EstimationFunction", "R3EstimationFunction", "R4EstimationFunction", "R5EstimationFunction", "R6EstimationFunction", "R7EstimationFunction", "R8EstimationFunction", "R9EstimationFunction", "molap"})
    public static final class EstimationType
    extends Enum<EstimationType> {
        public static final /* enum */ EstimationType LEGACY;
        public static final /* enum */ EstimationType R_1;
        public static final /* enum */ EstimationType R_2;
        public static final /* enum */ EstimationType R_3;
        public static final /* enum */ EstimationType R_4;
        public static final /* enum */ EstimationType R_5;
        public static final /* enum */ EstimationType R_6;
        public static final /* enum */ EstimationType R_7;
        public static final /* enum */ EstimationType R_8;
        public static final /* enum */ EstimationType R_9;
        private static final /* synthetic */ EstimationType[] $VALUES;
        @NotNull
        private final String longName;
        private final EstimationFunction func;

        static {
            EstimationType[] estimationTypeArray = new EstimationType[10];
            EstimationType[] estimationTypeArray2 = estimationTypeArray;
            estimationTypeArray[0] = LEGACY = new EstimationType("Legacy Apache Commons Math", new LegacyEstimationFunction());
            estimationTypeArray[1] = R_1 = new EstimationType("R-1", new R1EstimationFunction());
            estimationTypeArray[2] = R_2 = new EstimationType("R-2", new R2EstimationFunction());
            estimationTypeArray[3] = R_3 = new EstimationType("R-3", new R3EstimationFunction());
            estimationTypeArray[4] = R_4 = new EstimationType("R-4", new R4EstimationFunction());
            estimationTypeArray[5] = R_5 = new EstimationType("R-5", new R5EstimationFunction());
            estimationTypeArray[6] = R_6 = new EstimationType("R-6", new R6EstimationFunction());
            estimationTypeArray[7] = R_7 = new EstimationType("R-7", new R7EstimationFunction());
            estimationTypeArray[8] = R_8 = new EstimationType("R-8", new R8EstimationFunction());
            estimationTypeArray[9] = R_9 = new EstimationType("R-9", new R9EstimationFunction());
            $VALUES = estimationTypeArray;
        }

        protected final double index(double p, int length) {
            return this.func.index(p, length);
        }

        protected final double estimate(@NotNull double[] work, @Nullable int[] pivotsHeap, double pos, int length, @NotNull KthSelector selector) {
            Intrinsics.checkNotNullParameter((Object)work, (String)"work");
            Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
            return this.func.estimate(work, pivotsHeap, pos, length, selector);
        }

        protected final double evaluate(@NotNull double[] work, @Nullable int[] pivotsHeap, double p, @NotNull KthSelector selector) {
            Intrinsics.checkNotNullParameter((Object)work, (String)"work");
            Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
            boolean bl = !(p > (double)100) && !(p < 0.0);
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "OUT_OF_BOUNDS_QUANTILE_VALUE";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            return this.estimate(work, pivotsHeap, this.index(p / 100.0, work.length), work.length, selector);
        }

        public final double evaluate(@NotNull double[] work, double p, @NotNull KthSelector selector) {
            Intrinsics.checkNotNullParameter((Object)work, (String)"work");
            Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
            return this.evaluate(work, null, p, selector);
        }

        @NotNull
        public final String getLongName() {
            return this.longName;
        }

        private EstimationType(String longName, EstimationFunction func) {
            this.longName = longName;
            this.func = func;
        }

        public static EstimationType[] values() {
            return (EstimationType[])$VALUES.clone();
        }

        public static EstimationType valueOf(String string) {
            return Enum.valueOf(EstimationType.class, string);
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/molap/aggregates/cube/UnivariateStatistics$EstimationType$LegacyEstimationFunction;", "Lorg/molap/aggregates/cube/UnivariateStatistics$AbstractEstimationFunction;", "()V", "index", "", "p", "length", "", "molap"})
        private static final class LegacyEstimationFunction
        extends AbstractEstimationFunction {
            @Override
            public double index(double p, int length) {
                double minLimit = 0.0;
                double maxLimit = 1.0;
                return Double.compare(p, minLimit) == 0 ? 0.0 : (Double.compare(p, maxLimit) == 0 ? (double)length : p * ((double)length + 1.0));
            }
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/molap/aggregates/cube/UnivariateStatistics$EstimationType$R1EstimationFunction;", "Lorg/molap/aggregates/cube/UnivariateStatistics$AbstractEstimationFunction;", "()V", "estimate", "", "values", "", "pivotsHeap", "", "pos", "length", "", "selector", "Lorg/molap/aggregates/cube/KthSelector;", "index", "p", "molap"})
        private static final class R1EstimationFunction
        extends AbstractEstimationFunction {
            @Override
            public double index(double p, int length) {
                double minLimit = 0.0;
                return Double.compare(p, minLimit) == 0 ? 0.0 : (double)length * p + 0.5;
            }

            @Override
            public double estimate(@NotNull double[] values, @Nullable int[] pivotsHeap, double pos, int length, @NotNull KthSelector selector) {
                Intrinsics.checkNotNullParameter((Object)values, (String)"values");
                Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
                double d = pos - 0.5;
                boolean bl = false;
                return super.estimate(values, pivotsHeap, Math.ceil(d), length, selector);
            }
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/molap/aggregates/cube/UnivariateStatistics$EstimationType$R2EstimationFunction;", "Lorg/molap/aggregates/cube/UnivariateStatistics$AbstractEstimationFunction;", "()V", "estimate", "", "values", "", "pivotsHeap", "", "pos", "length", "", "selector", "Lorg/molap/aggregates/cube/KthSelector;", "index", "p", "molap"})
        private static final class R2EstimationFunction
        extends AbstractEstimationFunction {
            @Override
            public double index(double p, int length) {
                double minLimit = 0.0;
                double maxLimit = 1.0;
                return Double.compare(p, maxLimit) == 0 ? (double)length : (Double.compare(p, minLimit) == 0 ? 0.0 : (double)length * p + 0.5);
            }

            @Override
            public double estimate(@NotNull double[] values, @Nullable int[] pivotsHeap, double pos, int length, @NotNull KthSelector selector) {
                Intrinsics.checkNotNullParameter((Object)values, (String)"values");
                Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
                double d = pos - 0.5;
                boolean bl = false;
                double low = super.estimate(values, pivotsHeap, Math.ceil(d), length, selector);
                double d2 = pos + 0.5;
                boolean bl2 = false;
                double high = super.estimate(values, pivotsHeap, Math.floor(d2), length, selector);
                return (low + high) / (double)2;
            }
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/molap/aggregates/cube/UnivariateStatistics$EstimationType$R3EstimationFunction;", "Lorg/molap/aggregates/cube/UnivariateStatistics$AbstractEstimationFunction;", "()V", "index", "", "p", "length", "", "molap"})
        private static final class R3EstimationFunction
        extends AbstractEstimationFunction {
            @Override
            public double index(double p, int length) {
                double d;
                double minLimit = 0.5 / (double)length;
                if (Double.compare(p, minLimit) <= 0) {
                    d = 0.0;
                } else {
                    double d2 = (double)length * p;
                    boolean bl = false;
                    d = Math.rint(d2);
                }
                return d;
            }
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/molap/aggregates/cube/UnivariateStatistics$EstimationType$R4EstimationFunction;", "Lorg/molap/aggregates/cube/UnivariateStatistics$AbstractEstimationFunction;", "()V", "index", "", "p", "length", "", "molap"})
        private static final class R4EstimationFunction
        extends AbstractEstimationFunction {
            @Override
            public double index(double p, int length) {
                double minLimit = 1.0 / (double)length;
                double maxLimit = 1.0;
                return Double.compare(p, minLimit) < 0 ? 0.0 : (Double.compare(p, maxLimit) == 0 ? (double)length : (double)length * p);
            }
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/molap/aggregates/cube/UnivariateStatistics$EstimationType$R5EstimationFunction;", "Lorg/molap/aggregates/cube/UnivariateStatistics$AbstractEstimationFunction;", "()V", "index", "", "p", "length", "", "molap"})
        private static final class R5EstimationFunction
        extends AbstractEstimationFunction {
            @Override
            public double index(double p, int length) {
                double minLimit = 0.5 / (double)length;
                double maxLimit = ((double)length - 0.5) / (double)length;
                return Double.compare(p, minLimit) < 0 ? 0.0 : (Double.compare(p, maxLimit) >= 0 ? (double)length : (double)length * p + 0.5);
            }
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/molap/aggregates/cube/UnivariateStatistics$EstimationType$R6EstimationFunction;", "Lorg/molap/aggregates/cube/UnivariateStatistics$AbstractEstimationFunction;", "()V", "index", "", "p", "length", "", "molap"})
        private static final class R6EstimationFunction
        extends AbstractEstimationFunction {
            @Override
            public double index(double p, int length) {
                double minLimit = 1.0 / (double)(length + 1);
                double maxLimit = 1.0 * (double)length / (double)(length + 1);
                return Double.compare(p, minLimit) < 0 ? 0.0 : (Double.compare(p, maxLimit) >= 0 ? (double)length : (double)(length + 1) * p);
            }
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/molap/aggregates/cube/UnivariateStatistics$EstimationType$R7EstimationFunction;", "Lorg/molap/aggregates/cube/UnivariateStatistics$AbstractEstimationFunction;", "()V", "index", "", "p", "length", "", "molap"})
        private static final class R7EstimationFunction
        extends AbstractEstimationFunction {
            @Override
            public double index(double p, int length) {
                double minLimit = 0.0;
                double maxLimit = 1.0;
                return Double.compare(p, minLimit) == 0 ? 0.0 : (Double.compare(p, maxLimit) == 0 ? (double)length : 1.0 + (double)(length - 1) * p);
            }
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/molap/aggregates/cube/UnivariateStatistics$EstimationType$R8EstimationFunction;", "Lorg/molap/aggregates/cube/UnivariateStatistics$AbstractEstimationFunction;", "()V", "index", "", "p", "length", "", "molap"})
        private static final class R8EstimationFunction
        extends AbstractEstimationFunction {
            @Override
            public double index(double p, int length) {
                double minLimit = 0.6666666666666666 / ((double)length + 0.3333333333333333);
                double maxLimit = ((double)length - 0.3333333333333333) / ((double)length + 0.3333333333333333);
                return Double.compare(p, minLimit) < 0 ? 0.0 : (Double.compare(p, maxLimit) >= 0 ? (double)length : ((double)length + 0.3333333333333333) * p + 0.3333333333333333);
            }
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/molap/aggregates/cube/UnivariateStatistics$EstimationType$R9EstimationFunction;", "Lorg/molap/aggregates/cube/UnivariateStatistics$AbstractEstimationFunction;", "()V", "index", "", "p", "length", "", "molap"})
        private static final class R9EstimationFunction
        extends AbstractEstimationFunction {
            @Override
            public double index(double p, int length) {
                double minLimit = 0.625 / ((double)length + 0.25);
                double maxLimit = ((double)length - 0.375) / ((double)length + 0.25);
                return Double.compare(p, minLimit) < 0 ? 0.0 : (Double.compare(p, maxLimit) >= 0 ? (double)length : ((double)length + 0.25) * p + 0.375);
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J2\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH&J\u0018\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH&\u00a8\u0006\u000f"}, d2={"Lorg/molap/aggregates/cube/UnivariateStatistics$EstimationFunction;", "", "estimate", "", "work", "", "pivotsHeap", "", "pos", "length", "", "selector", "Lorg/molap/aggregates/cube/KthSelector;", "index", "p", "molap"})
    public static interface EstimationFunction {
        public double index(double var1, int var3);

        public double estimate(@NotNull double[] var1, @Nullable int[] var2, double var3, int var5, @NotNull KthSelector var6);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/molap/aggregates/cube/UnivariateStatistics$AbstractEstimationFunction;", "Lorg/molap/aggregates/cube/UnivariateStatistics$EstimationFunction;", "()V", "estimate", "", "work", "", "pivotsHeap", "", "pos", "length", "", "selector", "Lorg/molap/aggregates/cube/KthSelector;", "molap"})
    public static abstract class AbstractEstimationFunction
    implements EstimationFunction {
        @Override
        public double estimate(@NotNull double[] work, @Nullable int[] pivotsHeap, double pos, int length, @NotNull KthSelector selector) {
            Intrinsics.checkNotNullParameter((Object)work, (String)"work");
            Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
            boolean bl = false;
            double fpos = Math.floor(pos);
            int intPos = (int)fpos;
            double dif = pos - fpos;
            if (pos < 1.0) {
                return selector.select(work, pivotsHeap, 0);
            }
            if (pos >= (double)length) {
                return selector.select(work, pivotsHeap, length - 1);
            }
            double lower = selector.select(work, pivotsHeap, intPos - 1);
            double upper = selector.select(work, pivotsHeap, intPos);
            return lower + dif * (upper - lower);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lorg/molap/aggregates/cube/UnivariateStatistics$NumberComparator;", "Ljava/util/Comparator;", "", "Lkotlin/Comparator;", "()V", "compare", "", "o1", "o2", "molap"})
    private static final class NumberComparator
    implements Comparator<Number> {
        @Override
        public int compare(@NotNull Number o1, @NotNull Number o2) {
            Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
            return Double.compare(o1.doubleValue(), o2.doubleValue());
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/molap/aggregates/cube/UnivariateStatistics$Companion;", "", "()V", "numberComparator", "Ljava/util/Comparator;", "", "Lkotlin/Comparator;", "molap"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

