/*
 * Decompiled with CFR 0.152.
 */
package org.molap.dataframe;

import com.macrofocus.common.collection.CollectionFactory;
import com.macrofocus.common.collection.WeakReference;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.dataframe.DataFrame;
import org.molap.dataframe.DataFrameEvent;
import org.molap.dataframe.DataFrameListener;
import org.molap.index.UniqueIndex;
import org.molap.series.AbstractSeries;
import org.molap.series.Series;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u0000 -*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0004:\u0003,-.B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\fH\u0016J\u001c\u0010\u0012\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\fH\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u0014H\u0016J#\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0002\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0015\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0015\u0010\u001b\u001a\u00028\u00012\u0006\u0010\u001c\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0017\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0017\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010 J\u0015\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0015\u0010#\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u001c\u0010$\u001a\u00020\u00102\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010&H\u0004J\b\u0010'\u001a\u00020\u0010H\u0016J\b\u0010(\u001a\u00020\u0010H\u0016J\u001c\u0010)\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\fH\u0016J\b\u0010*\u001a\u00020\u0010H\u0016J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR \u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\t\u00a8\u0006/"}, d2={"Lorg/molap/dataframe/AbstractDataFrame;", "Row", "Column", "V", "Lorg/molap/dataframe/DataFrame;", "()V", "columnCount", "", "getColumnCount", "()I", "listeners", "", "Lorg/molap/dataframe/DataFrameListener;", "rowCount", "getRowCount", "addDataFrameListener", "", "listener", "addWeakDataFrameListener", "columns", "", "getColumn", "Lorg/molap/series/Series;", "column", "(Ljava/lang/Object;)Lorg/molap/series/Series;", "getColumnAddress", "(Ljava/lang/Object;)I", "getColumnKey", "index", "(I)Ljava/lang/Object;", "getColumnName", "", "(Ljava/lang/Object;)Ljava/lang/String;", "getRowAddress", "row", "getRowKey", "notifyDataFrameChanged", "event", "Lorg/molap/dataframe/DataFrameEvent;", "print", "printSchema", "removeDataFrameListener", "removeDataFrameListeners", "rows", "ColumnSeries", "Companion", "WeakDataFrameListener", "molap"})
public abstract class AbstractDataFrame<Row, Column, V>
implements DataFrame<Row, Column, V> {
    private final List<DataFrameListener<Row, Column>> listeners = CollectionFactory.INSTANCE.copyOnWriteArrayList();
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public Iterable<Row> rows() {
        return this.getRowIndex().keys();
    }

    @Override
    @NotNull
    public Iterable<Column> columns() {
        return this.getColumnIndex().keys();
    }

    @Override
    public Row getRowKey(int index) {
        return (Row)this.getRowIndex().getKey(index);
    }

    @Override
    public Column getColumnKey(int index) {
        return (Column)this.getColumnIndex().getKey(index);
    }

    @Override
    public int getRowAddress(Row row) {
        return this.getRowIndex().getAddress(row);
    }

    @Override
    public int getColumnAddress(Column column) {
        return this.getColumnIndex().getAddress(column);
    }

    @Override
    public int getRowCount() {
        return this.getRowIndex().getSize();
    }

    @Override
    public int getColumnCount() {
        return this.getColumnIndex().getSize();
    }

    @Override
    @Nullable
    public Series<Row, V> getColumn(Column column) {
        return new ColumnSeries(column);
    }

    @Override
    @Nullable
    public String getColumnName(Column column) {
        Column Column2 = column;
        return Column2 != null ? Column2.toString() : null;
    }

    @Override
    public void printSchema() {
        for (Column column : this.columns()) {
            String string = Companion.abbreviate(this.getColumnName(column), 19);
            boolean bl = false;
            System.out.print((Object)string);
            string = ": ";
            bl = false;
            System.out.print((Object)string);
            KClass<Object> value = this.getColumnClass(column);
            String string2 = Companion.abbreviate(value != null ? value.getSimpleName() : "", 19);
            boolean bl2 = false;
            System.out.print((Object)string2);
            bl = false;
            System.out.println();
        }
    }

    @Override
    public void print() {
    }

    @Override
    public void addDataFrameListener(@NotNull DataFrameListener<Row, Column> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.listeners.add(listener);
    }

    @Override
    public void addWeakDataFrameListener(@NotNull DataFrameListener<Row, Column> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.listeners.add(new WeakDataFrameListener(listener));
    }

    @Override
    public void removeDataFrameListener(@NotNull DataFrameListener<Row, Column> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        if (listener instanceof WeakDataFrameListener) {
            this.listeners.remove(listener);
        } else {
            DataFrameListener<Row, Column> toRemove = null;
            for (DataFrameListener<Row, Column> dataFrameListener2 : this.listeners) {
                DataFrameListener<Row, Column> comparable = null;
                comparable = dataFrameListener2 instanceof WeakDataFrameListener ? ((WeakDataFrameListener)dataFrameListener2).getReference() : dataFrameListener2;
                if (!Intrinsics.areEqual(listener, comparable)) continue;
                toRemove = dataFrameListener2;
            }
            if (toRemove != null) {
                this.listeners.remove(toRemove);
            }
        }
    }

    @Override
    public void removeDataFrameListeners() {
        this.listeners.clear();
    }

    protected final void notifyDataFrameChanged(@NotNull DataFrameEvent<Row, Column> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        for (DataFrameListener<Row, Column> listener : this.listeners) {
            listener.dataFrameChanged(event);
        }
    }

    protected AbstractDataFrame() {
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0001\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\fH\u0016R \u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lorg/molap/dataframe/AbstractDataFrame$WeakDataFrameListener;", "Lorg/molap/dataframe/DataFrameListener;", "listener", "(Lorg/molap/dataframe/AbstractDataFrame;Lorg/molap/dataframe/DataFrameListener;)V", "l_ref", "Lcom/macrofocus/common/collection/WeakReference;", "reference", "getReference", "()Lorg/molap/dataframe/DataFrameListener;", "dataFrameChanged", "", "event", "Lorg/molap/dataframe/DataFrameEvent;", "molap"})
    private final class WeakDataFrameListener
    implements DataFrameListener<Row, Column> {
        private final WeakReference<DataFrameListener<Row, Column>> l_ref;

        @Override
        public void dataFrameChanged(@NotNull DataFrameEvent<Row, Column> event) {
            Intrinsics.checkNotNullParameter(event, (String)"event");
            DataFrameListener l = this.getReference();
            if (l != null) {
                l.dataFrameChanged(event);
            } else {
                AbstractDataFrame.this.removeDataFrameListener(this);
            }
        }

        @Nullable
        public final DataFrameListener<Row, Column> getReference() {
            return (DataFrameListener)this.l_ref.get();
        }

        public WeakDataFrameListener(DataFrameListener<Row, Column> listener) {
            Intrinsics.checkNotNullParameter(listener, (String)"listener");
            this.l_ref = new WeakReference(listener);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0010\u001a\u00028\u00022\u0006\u0010\u0011\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0012J\u0015\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0015\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0018J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aH\u0016J;\u0010\u001b\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u0001H\u001d\u0012\u0006\u0012\u0004\u0018\u00018\u0002\u0018\u00010\u001c\"\u0004\b\u0003\u0010\u001d2\u0016\u0010\u0019\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u0001H\u001d0\u001e\"\u0004\u0018\u0001H\u001d\u00a2\u0006\u0002\u0010\u001fJ\b\u0010 \u001a\u00020\u0014H\u0016R\u001c\u0010\u0002\u001a\u00028\u0001X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\b\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007R\u0016\u0010\t\u001a\u0004\u0018\u00010\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0005R\u001c\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006!"}, d2={"Lorg/molap/dataframe/AbstractDataFrame$ColumnSeries;", "Lorg/molap/series/AbstractSeries;", "column", "(Lorg/molap/dataframe/AbstractDataFrame;Ljava/lang/Object;)V", "getColumn", "()Ljava/lang/Object;", "setColumn", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "name", "", "getName", "type", "Lkotlin/reflect/KClass;", "getType", "()Lkotlin/reflect/KClass;", "get", "key", "(Ljava/lang/Object;)Ljava/lang/Object;", "getAddress", "", "(Ljava/lang/Object;)I", "getKey", "i", "(I)Ljava/lang/Object;", "keys", "", "reindex", "Lorg/molap/series/Series;", "L", "", "([Ljava/lang/Object;)Lorg/molap/series/Series;", "size", "molap"})
    public final class ColumnSeries
    extends AbstractSeries<Row, V> {
        private Column column;

        @Override
        @Nullable
        public Object getName() {
            return this.column;
        }

        @Override
        @NotNull
        public KClass<? extends Object> getType() {
            return AbstractDataFrame.this.getColumnClass(this.column);
        }

        @Override
        public V get(Row key) {
            return AbstractDataFrame.this.getValueAt(key, this.column);
        }

        @Override
        public Row getKey(int i) {
            UniqueIndex uniqueIndex = AbstractDataFrame.this.getRowIndex();
            Intrinsics.checkNotNull(uniqueIndex);
            return uniqueIndex.getKey(i);
        }

        @Override
        public int size() {
            return AbstractDataFrame.this.getRowIndex().getSize();
        }

        @Override
        public int getAddress(Row key) {
            return AbstractDataFrame.this.getRowAddress(key);
        }

        @Override
        @NotNull
        public Iterable<Row> keys() {
            UniqueIndex uniqueIndex = AbstractDataFrame.this.getRowIndex();
            Intrinsics.checkNotNull(uniqueIndex);
            return uniqueIndex.keys();
        }

        @Nullable
        public final <L> Series<L, V> reindex(L ... keys2) {
            Intrinsics.checkNotNullParameter(keys2, (String)"keys");
            return null;
        }

        public final Column getColumn() {
            return this.column;
        }

        public final void setColumn(Column Column2) {
            this.column = Column2;
        }

        public ColumnSeries(Column column) {
            this.column = column;
            this.column = this.column;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/molap/dataframe/AbstractDataFrame$Companion;", "", "()V", "abbreviate", "", "str", "maxWidth", "", "molap"})
    public static final class Companion {
        @Nullable
        public final String abbreviate(@Nullable String str, int maxWidth) {
            String string;
            if (str == null) {
                return null;
            }
            if (str.length() <= maxWidth) {
                string = str;
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                String string2 = str;
                int n = 0;
                int n2 = maxWidth - 3;
                boolean bl = false;
                String string3 = string2.substring(n, n2);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                string = stringBuilder.append(string3).append("...").toString();
            }
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

