/*
 * Decompiled with CFR 0.152.
 */
package org.molap.dataframe;

import com.macrofocus.common.json.Json;
import com.macrofocus.common.json.JsonArray;
import com.macrofocus.common.json.JsonObject;
import com.macrofocus.common.json.JsonType;
import com.macrofocus.common.json.JsonValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.dataframe.AbstractDataFrame;
import org.molap.dataframe.DataFrame;
import org.molap.index.DefaultUniqueIndex;
import org.molap.index.IntegerRangeUniqueIndex;
import org.molap.index.UniqueIndex;
import org.molap.series.Series;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 /2\u0016\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0001:\u0001/B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006B\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u001c\u001a\b\u0012\u0002\b\u0003\u0018\u00010\f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0014\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010 \u001a\u00020\u0003H\u0016J\u0012\u0010!\u001a\u0004\u0018\u00010\u00032\u0006\u0010 \u001a\u00020\u0003H\u0016J\u0014\u0010\"\u001a\u0004\u0018\u00010\u00042\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J!\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0002\b\u0003\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0002\u0010&J\u0016\u0010'\u001a\b\u0012\u0002\b\u0003\u0018\u00010\f2\u0006\u0010(\u001a\u00020\u0002H\u0016J\u001a\u0010)\u001a\u0004\u0018\u00010\u00042\u0006\u0010(\u001a\u00020\u00022\u0006\u0010 \u001a\u00020\u0003H\u0016J=\u0010*\u001a\u0010\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010+2\u0010\u0010,\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010$2\u0010\u0010-\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010\u000b\u00a2\u0006\u0002\u0010.R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\f0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR!\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R!\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0013\u001a\u0004\b\u001a\u0010\u0011\u00a8\u00060"}, d2={"Lorg/molap/dataframe/JsonDataFrame;", "Lorg/molap/dataframe/AbstractDataFrame;", "", "", "", "json", "(Ljava/lang/String;)V", "array", "Lcom/macrofocus/common/json/JsonArray;", "(Lcom/macrofocus/common/json/JsonArray;)V", "classes", "", "Lkotlin/reflect/KClass;", "[Lkotlin/reflect/KClass;", "columnIndex", "Lorg/molap/index/UniqueIndex;", "getColumnIndex", "()Lorg/molap/index/UniqueIndex;", "columnIndex$delegate", "Lkotlin/Lazy;", "labels", "[Ljava/lang/String;", "rowCount", "getRowCount", "()I", "rowIndex", "getRowIndex", "rowIndex$delegate", "getClass", "value", "Lcom/macrofocus/common/json/JsonValue;", "getColumnClass", "column", "getColumnName", "getObject", "getRow", "Lorg/molap/series/Series;", "integer", "(Ljava/lang/Integer;)Lorg/molap/series/Series;", "getRowClass", "row", "getValueAt", "join", "Lorg/molap/dataframe/DataFrame;", "series", "strings", "(Lorg/molap/series/Series;[Ljava/lang/String;)Lorg/molap/dataframe/DataFrame;", "Companion", "molap"})
public final class JsonDataFrame
extends AbstractDataFrame<Integer, String, Object> {
    private final String[] labels;
    private final KClass<?>[] classes;
    @NotNull
    private final Lazy rowIndex$delegate;
    @NotNull
    private final Lazy columnIndex$delegate;
    private final JsonArray array;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public UniqueIndex<Integer> getRowIndex() {
        Lazy lazy = this.rowIndex$delegate;
        JsonDataFrame jsonDataFrame = this;
        Object var3_3 = null;
        boolean bl = false;
        return (UniqueIndex)lazy.getValue();
    }

    @Override
    @NotNull
    public UniqueIndex<String> getColumnIndex() {
        Lazy lazy = this.columnIndex$delegate;
        JsonDataFrame jsonDataFrame = this;
        Object var3_3 = null;
        boolean bl = false;
        return (UniqueIndex)lazy.getValue();
    }

    @Override
    @Nullable
    public String getColumnName(@NotNull String column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        UniqueIndex<String> uniqueIndex = this.getColumnIndex();
        Intrinsics.checkNotNull(uniqueIndex);
        return this.labels[uniqueIndex.getAddress(column)];
    }

    @Override
    @NotNull
    public KClass<?> getColumnClass(@NotNull String column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        UniqueIndex<String> uniqueIndex = this.getColumnIndex();
        Intrinsics.checkNotNull(uniqueIndex);
        KClass<?> kClass = this.classes[uniqueIndex.getAddress(column)];
        Intrinsics.checkNotNull(kClass);
        return kClass;
    }

    @Override
    public int getRowCount() {
        return this.array.length();
    }

    @Override
    @Nullable
    public KClass<?> getRowClass(int row) {
        return Reflection.getOrCreateKotlinClass(Object.class);
    }

    @Override
    @Nullable
    public Object getValueAt(int row, @NotNull String column) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        JsonObject jsonObject = (JsonObject)this.array.get(row);
        JsonValue jsonValue = jsonObject.get(column);
        if (jsonValue != null && (jsonValue.getType() == JsonType.NULL || jsonValue.getType() == null)) {
            object = null;
        } else if (Intrinsics.areEqual(this.getColumnClass(column), Double.TYPE)) {
            object = jsonObject.getNumber(column);
        } else if (Intrinsics.areEqual(this.getColumnClass(column), Boolean.TYPE)) {
            object = jsonObject.getBoolean(column);
        } else {
            Object object2;
            try {
                object2 = this.getObject(jsonValue);
            }
            catch (AssertionError e) {
                ((Throwable)((Object)e)).printStackTrace();
                object2 = null;
            }
            object = object2;
        }
        return object;
    }

    @Nullable
    public final Series<String, ?> getRow(@Nullable Integer integer) {
        return null;
    }

    @Nullable
    public final DataFrame<?, ?, ?> join(@Nullable Series<?, ?> series, @Nullable String[] strings) {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final Object getObject(JsonValue value) {
        Object object;
        if (value != null) {
            if (value.getType() == JsonType.STRING) {
                object = value.asString();
            } else if (value.getType() == JsonType.NUMBER) {
                object = value.asNumber();
            } else if (value.getType() == JsonType.BOOLEAN) {
                object = value.asBoolean();
            } else if (value.getType() == JsonType.ARRAY) {
                void var3_3;
                JsonArray array = (JsonArray)value;
                Object[] a = new Object[array.length()];
                int n = 0;
                int n2 = array.length();
                while (n < n2) {
                    void i;
                    a[i] = this.getObject(array.get((int)i));
                    ++i;
                }
                object = var3_3;
            } else {
                object = value.getType() == JsonType.OBJECT ? value.toNative() : (value.getType() == JsonType.NULL ? null : value.asString());
            }
        } else {
            object = null;
        }
        return object;
    }

    private final KClass<?> getClass(JsonValue value) {
        return value.getType() == JsonType.NULL ? null : (value.getType() == JsonType.STRING ? Reflection.getOrCreateKotlinClass(String.class) : (value.getType() == JsonType.NUMBER ? Reflection.getOrCreateKotlinClass(Double.TYPE) : (value.getType() == JsonType.BOOLEAN ? Reflection.getOrCreateKotlinClass(Boolean.TYPE) : (value.getType() == JsonType.ARRAY ? Reflection.getOrCreateKotlinClass(Object[].class) : (value.getType() == JsonType.OBJECT ? Reflection.getOrCreateKotlinClass(JsonObject.class) : Reflection.getOrCreateKotlinClass(String.class))))));
    }

    /*
     * WARNING - void declaration
     */
    public JsonDataFrame(@NotNull JsonArray array) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        this.array = array;
        LinkedHashSet<String> columns = new LinkedHashSet<String>();
        HashMap types = new HashMap();
        int n = 0;
        int n2 = this.array.length();
        while (n < n2) {
            void row;
            JsonObject o = (JsonObject)this.array.get((int)row);
            for (String column : o.keys()) {
                KClass<?> type;
                JsonValue value;
                if (!columns.contains(column)) {
                    columns.add(column);
                    value = o.get(column);
                    type = this.getClass(value);
                    if (type == null) continue;
                    ((Map)types).put(column, type);
                    continue;
                }
                value = o.get(column);
                type = this.getClass(value);
                if (type == null) continue;
                KClass currentType = (KClass)types.get(column);
                if (currentType == null) {
                    ((Map)types).put(column, type);
                    continue;
                }
                if (!(Intrinsics.areEqual((Object)currentType, type) ^ true)) continue;
                ((Map)types).put(column, Reflection.getOrCreateKotlinClass(Object.class));
            }
            ++row;
        }
        this.labels = new String[columns.size()];
        this.classes = new KClass[columns.size()];
        int index = 0;
        Iterator iterator2 = columns.iterator();
        while (iterator2.hasNext()) {
            String column;
            this.labels[index] = column = (String)iterator2.next();
            KClass type = (KClass)types.get(column);
            KClass kClass = type;
            if (kClass == null) {
                kClass = Reflection.getOrCreateKotlinClass(Object.class);
            }
            this.classes[index] = kClass;
            ++index;
        }
        this.rowIndex$delegate = LazyKt.lazy((Function0)((Function0)new Function0<IntegerRangeUniqueIndex>(this){
            final /* synthetic */ JsonDataFrame this$0;

            @NotNull
            public final IntegerRangeUniqueIndex invoke() {
                return new IntegerRangeUniqueIndex(0, JsonDataFrame.access$getArray$p(this.this$0).length() - 1);
            }
            {
                this.this$0 = jsonDataFrame;
                super(0);
            }
        }));
        this.columnIndex$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DefaultUniqueIndex<String>>(this){
            final /* synthetic */ JsonDataFrame this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final DefaultUniqueIndex<String> invoke() {
                ArrayList<String> names = new ArrayList<String>(JsonDataFrame.access$getLabels$p(this.this$0).length);
                int n = 0;
                int n2 = JsonDataFrame.access$getLabels$p(this.this$0).length;
                while (n < n2) {
                    void c;
                    String string = JsonDataFrame.access$getLabels$p(this.this$0)[c];
                    Intrinsics.checkNotNull((Object)string);
                    names.add(string);
                    ++c;
                }
                return new DefaultUniqueIndex<String>((List)names);
            }
            {
                this.this$0 = jsonDataFrame;
                super(0);
            }
        }));
    }

    public JsonDataFrame(@NotNull String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        JsonValue jsonValue = Json.INSTANCE.instance().parse(json);
        if (jsonValue == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.macrofocus.common.json.JsonObject");
        }
        JsonValue jsonValue2 = ((JsonObject)jsonValue).get("data");
        if (jsonValue2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.macrofocus.common.json.JsonArray");
        }
        this((JsonArray)jsonValue2);
    }

    public static final /* synthetic */ JsonArray access$getArray$p(JsonDataFrame $this) {
        return $this.array;
    }

    public static final /* synthetic */ String[] access$getLabels$p(JsonDataFrame $this) {
        return $this.labels;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/molap/dataframe/JsonDataFrame$Companion;", "", "()V", "logger", "Ljava/util/logging/Logger;", "getLogger", "()Ljava/util/logging/Logger;", "molap"})
    public static final class Companion {
        private final Logger getLogger() {
            Logger logger = Logger.getLogger(JsonDataFrame.class.getName());
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getLogger(JsonDataFrame::class.java.name)");
            return logger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

