/*
 * Decompiled with CFR 0.152.
 */
package org.molap.dataframe;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.dataframe.AbstractMutableDataFrame;
import org.molap.dataframe.DataFrame;
import org.molap.dataframe.DataFrameEvent;
import org.molap.dataframe.DataFrameListener;
import org.molap.dataframe.MutableDataFrame;
import org.molap.dataframe.ReMappedRecipe;
import org.molap.index.UniqueIndex;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\n\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00042\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0005B3\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0019\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001f2\u0006\u0010 \u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010!J\u001b\u0010\"\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001f2\u0006\u0010#\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010!J\u001d\u0010$\u001a\u00028\u00022\u0006\u0010#\u001a\u00028\u00002\u0006\u0010 \u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010%J\b\u0010&\u001a\u00020'H\u0004J\b\u0010(\u001a\u00020'H\u0004J\b\u0010)\u001a\u00020'H\u0004J \u0010*\u001a\u00020'2\u0018\u0010+\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0007J\u001a\u0010,\u001a\u00020'2\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\tJ%\u0010-\u001a\u00020'2\u0006\u0010#\u001a\u00028\u00002\u0006\u0010 \u001a\u00028\u00012\u0006\u0010.\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010/J\b\u00100\u001a\u00020'H\u0004R\"\u0010\u000b\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\"\u0010\u0011\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00010\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000eR\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u000e\u00a8\u00061"}, d2={"Lorg/molap/dataframe/ReMappedDataFrame;", "R", "C", "V", "Lorg/molap/dataframe/AbstractMutableDataFrame;", "Lorg/molap/dataframe/MutableDataFrame;", "originalDataFrame", "Lorg/molap/dataframe/DataFrame;", "recipe", "Lorg/molap/dataframe/ReMappedRecipe;", "(Lorg/molap/dataframe/DataFrame;Lorg/molap/dataframe/ReMappedRecipe;)V", "cacheColumnIndex", "Lorg/molap/index/UniqueIndex;", "getCacheColumnIndex", "()Lorg/molap/index/UniqueIndex;", "setCacheColumnIndex", "(Lorg/molap/index/UniqueIndex;)V", "cacheRowIndex", "getCacheRowIndex", "setCacheRowIndex", "columnIndex", "getColumnIndex", "dataFrameListener", "Lorg/molap/dataframe/DataFrameListener;", "getOriginalDataFrame", "()Lorg/molap/dataframe/DataFrame;", "setOriginalDataFrame", "(Lorg/molap/dataframe/DataFrame;)V", "rowIndex", "getRowIndex", "getColumnClass", "Lkotlin/reflect/KClass;", "column", "(Ljava/lang/Object;)Lkotlin/reflect/KClass;", "getRowClass", "row", "getValueAt", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "invalidate", "", "originalDataFrameChanged", "scheduleUpdate", "setDataFrame", "dataFrame", "setRecipe", "setValueAt", "value", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "updateImmediatelly", "molap"})
public class ReMappedDataFrame<R, C, V>
extends AbstractMutableDataFrame<R, C, V>
implements MutableDataFrame<R, C, V> {
    @Nullable
    private UniqueIndex<C> cacheColumnIndex;
    @Nullable
    private UniqueIndex<R> cacheRowIndex;
    private ReMappedRecipe<R, C> recipe;
    private final DataFrameListener<R, C> dataFrameListener;
    @NotNull
    private DataFrame<R, C, V> originalDataFrame;

    @Nullable
    public final UniqueIndex<C> getCacheColumnIndex() {
        return this.cacheColumnIndex;
    }

    public final void setCacheColumnIndex(@Nullable UniqueIndex<C> uniqueIndex) {
        this.cacheColumnIndex = uniqueIndex;
    }

    @Nullable
    public final UniqueIndex<R> getCacheRowIndex() {
        return this.cacheRowIndex;
    }

    public final void setCacheRowIndex(@Nullable UniqueIndex<R> uniqueIndex) {
        this.cacheRowIndex = uniqueIndex;
    }

    @Override
    @NotNull
    public UniqueIndex<C> getColumnIndex() {
        UniqueIndex<C> uniqueIndex;
        if (this.cacheColumnIndex == null) {
            UniqueIndex<C> uniqueIndex2 = this.cacheColumnIndex = this.recipe.buildColumnIndex();
            uniqueIndex = uniqueIndex2;
            Intrinsics.checkNotNull(uniqueIndex2);
        } else {
            UniqueIndex<C> uniqueIndex3 = this.cacheColumnIndex;
            uniqueIndex = uniqueIndex3;
            Intrinsics.checkNotNull(uniqueIndex3);
        }
        return uniqueIndex;
    }

    @Override
    @NotNull
    public UniqueIndex<R> getRowIndex() {
        UniqueIndex<R> uniqueIndex;
        if (this.cacheRowIndex == null) {
            UniqueIndex<R> uniqueIndex2 = this.cacheRowIndex = this.recipe.buildRowIndex();
            uniqueIndex = uniqueIndex2;
            Intrinsics.checkNotNull(uniqueIndex2);
        } else {
            UniqueIndex<R> uniqueIndex3 = this.cacheRowIndex;
            uniqueIndex = uniqueIndex3;
            Intrinsics.checkNotNull(uniqueIndex3);
        }
        return uniqueIndex;
    }

    public final void setDataFrame(@NotNull DataFrame<R, C, V> dataFrame) {
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        if (this.getOriginalDataFrame() != dataFrame) {
            if (this.getOriginalDataFrame() != null) {
                this.getOriginalDataFrame().removeDataFrameListener(this.dataFrameListener);
            }
            this.setOriginalDataFrame(dataFrame);
            if (this.getOriginalDataFrame() != null) {
                this.getOriginalDataFrame().addDataFrameListener(this.dataFrameListener);
            }
            this.invalidate();
            this.scheduleUpdate();
        }
    }

    public final void setRecipe(@NotNull ReMappedRecipe<R, C> recipe2) {
        Intrinsics.checkNotNullParameter(recipe2, (String)"recipe");
        if (this.recipe != recipe2) {
            this.recipe = recipe2;
            this.invalidate();
            this.scheduleUpdate();
        }
    }

    protected final void originalDataFrameChanged() {
        this.invalidate();
        this.scheduleUpdate();
    }

    protected final void invalidate() {
        this.cacheRowIndex = null;
        this.cacheColumnIndex = null;
    }

    protected final void scheduleUpdate() {
        this.updateImmediatelly();
    }

    protected final void updateImmediatelly() {
        this.notifyDataFrameChanged(new DataFrameEvent(CollectionsKt.emptyList(), CollectionsKt.emptyList(), true));
    }

    @Override
    @Nullable
    public KClass<?> getRowClass(R row) {
        DataFrame<R, C, V> dataFrame = this.getOriginalDataFrame();
        Intrinsics.checkNotNull(dataFrame);
        return dataFrame.getRowClass(row);
    }

    @Override
    @NotNull
    public KClass<?> getColumnClass(C column) {
        DataFrame<R, C, V> dataFrame = this.getOriginalDataFrame();
        Intrinsics.checkNotNull(dataFrame);
        return dataFrame.getColumnClass(column);
    }

    @Override
    public V getValueAt(R row, C column) {
        DataFrame<R, C, V> dataFrame = this.getOriginalDataFrame();
        Intrinsics.checkNotNull(dataFrame);
        return dataFrame.getValueAt(row, column);
    }

    @Override
    public void setValueAt(R row, C column, V value) {
        if (this.getOriginalDataFrame() instanceof MutableDataFrame) {
            DataFrame<R, C, V> dataFrame = this.getOriginalDataFrame();
            if (dataFrame == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.molap.dataframe.MutableDataFrame<R, C, V>");
            }
            ((MutableDataFrame)dataFrame).setValueAt(row, column, value);
        }
    }

    @NotNull
    public DataFrame<R, C, V> getOriginalDataFrame() {
        return this.originalDataFrame;
    }

    public void setOriginalDataFrame(@NotNull DataFrame<R, C, V> dataFrame) {
        Intrinsics.checkNotNullParameter(dataFrame, (String)"<set-?>");
        this.originalDataFrame = dataFrame;
    }

    public ReMappedDataFrame(@NotNull DataFrame<R, C, V> originalDataFrame, @NotNull ReMappedRecipe<R, C> recipe2) {
        Intrinsics.checkNotNullParameter(originalDataFrame, (String)"originalDataFrame");
        Intrinsics.checkNotNullParameter(recipe2, (String)"recipe");
        this.originalDataFrame = originalDataFrame;
        this.dataFrameListener = new DataFrameListener<R, C>(this){
            final /* synthetic */ ReMappedDataFrame this$0;

            public void dataFrameChanged(@NotNull DataFrameEvent<R, C> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                this.this$0.originalDataFrameChanged();
            }
            {
                this.this$0 = this$0;
            }
        };
        this.recipe = recipe2;
        if (this.getOriginalDataFrame() != null) {
            this.getOriginalDataFrame().addWeakDataFrameListener(this.dataFrameListener);
        }
    }
}

