/*
 * Decompiled with CFR 0.152.
 */
package org.molap.dataframe;

import com.macrofocus.common.collection.UniversalComparator;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.dataframe.AbstractDataFrame;
import org.molap.dataframe.SortKey;
import org.molap.dataframe.SortOrder;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B3\b\u0016\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u001a\u0010\u0007\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\t0\bj\n\u0012\u0006\u0012\u0004\u0018\u00010\t`\n\u00a2\u0006\u0002\u0010\u000bJ=\u0010\u0015\u001a\u00020\u0016\"\u0004\b\u0001\u0010\u00172\u0018\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t0\u00192\u0006\u0010\u001a\u001a\u0002H\u00172\u0006\u0010\u001b\u001a\u0002H\u0017H\u0016\u00a2\u0006\u0002\u0010\u001cJ\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\tH\u0096\u0002J\b\u0010 \u001a\u00020\u0016H\u0016R\u0016\u0010\u0003\u001a\u00028\u0000X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR.\u0010\u0007\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\t0\bj\n\u0012\u0006\u0012\u0004\u0018\u00010\t`\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Lorg/molap/dataframe/SingleSortKey;", "Column", "Lorg/molap/dataframe/SortKey;", "column", "sortOrder", "Lorg/molap/dataframe/SortOrder;", "(Ljava/lang/Object;Lorg/molap/dataframe/SortOrder;)V", "comparator", "Ljava/util/Comparator;", "", "Lkotlin/Comparator;", "(Ljava/lang/Object;Lorg/molap/dataframe/SortOrder;Ljava/util/Comparator;)V", "getColumn", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getComparator", "()Ljava/util/Comparator;", "setComparator", "(Ljava/util/Comparator;)V", "getSortOrder", "()Lorg/molap/dataframe/SortOrder;", "compare", "", "Row", "dataFrame", "Lorg/molap/dataframe/AbstractDataFrame;", "o1", "o2", "(Lorg/molap/dataframe/AbstractDataFrame;Ljava/lang/Object;Ljava/lang/Object;)I", "equals", "", "other", "hashCode", "molap"})
public final class SingleSortKey<Column>
implements SortKey<Column> {
    private final Column column;
    @NotNull
    private final SortOrder sortOrder;
    @NotNull
    private Comparator<Object> comparator;

    @Override
    public Column getColumn() {
        return this.column;
    }

    @Override
    @NotNull
    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    @Override
    @NotNull
    public Comparator<Object> getComparator() {
        return this.comparator;
    }

    public void setComparator(@NotNull Comparator<Object> comparator) {
        Intrinsics.checkNotNullParameter(comparator, (String)"<set-?>");
        this.comparator = comparator;
    }

    @Override
    public <Row> int compare(@NotNull AbstractDataFrame<Row, Column, Object> dataFrame, Row o1, Row o2) {
        int n;
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        if (this.getSortOrder() != SortOrder.UNSORTED) {
            Object v1 = dataFrame.getValueAt(o1, this.getColumn());
            Object v2 = dataFrame.getValueAt(o2, this.getColumn());
            int compare = this.getComparator().compare(v1, v2);
            n = this.getSortOrder() == SortOrder.ASCENDING ? compare : -compare;
        } else {
            n = -2;
        }
        return n;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)Reflection.getOrCreateKotlinClass(other.getClass())) ^ true) {
            return false;
        }
        SingleSortKey cfr_ignored_0 = (SingleSortKey)other;
        if (Intrinsics.areEqual(this.getColumn(), ((SingleSortKey)other).getColumn()) ^ true) {
            return false;
        }
        if (this.getSortOrder() != ((SingleSortKey)other).getSortOrder()) {
            return false;
        }
        return !(Intrinsics.areEqual(this.getComparator(), ((SingleSortKey)other).getComparator()) ^ true);
    }

    public int hashCode() {
        Column Column2 = this.getColumn();
        int result = Column2 != null ? Column2.hashCode() : 0;
        result = 31 * result + this.getSortOrder().hashCode();
        result = 31 * result + this.getComparator().hashCode();
        return result;
    }

    public SingleSortKey(Column column, @NotNull SortOrder sortOrder) {
        Intrinsics.checkNotNullParameter((Object)((Object)sortOrder), (String)"sortOrder");
        this.column = column;
        this.sortOrder = sortOrder;
        this.setComparator((Comparator)new UniversalComparator());
    }

    public SingleSortKey(Column column, @NotNull SortOrder sortOrder, @NotNull Comparator<Object> comparator) {
        Intrinsics.checkNotNullParameter((Object)((Object)sortOrder), (String)"sortOrder");
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        this.column = column;
        this.sortOrder = sortOrder;
        this.setComparator(comparator);
    }
}

