/*
 * Decompiled with CFR 0.152.
 */
package org.molap.dataframe;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.molap.dataframe.DataFrame;
import org.molap.dataframe.DataFrameEvent;
import org.molap.dataframe.ReMappedDataFrame;
import org.molap.dataframe.ReMappedRecipe;
import org.molap.dataframe.WrappedDataFrame;
import org.molap.index.DefaultUniqueIndex;
import org.molap.index.UniqueIndex;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0012\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0004:\t23456789:B\u001f\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0006\u00a2\u0006\u0002\u0010\u0007JC\u0010\u0014\u001a\u00020\u001526\u0010\n\u001a\u001c\u0012\u0018\b\u0001\u0012\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\f0\u0016\"\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\f\u00a2\u0006\u0002\u0010\u0017J\u001f\u0010\u0018\u001a\u00020\u00152\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00010\u0016\"\u00028\u0001\u00a2\u0006\u0002\u0010\u0019J\u0006\u0010\u001a\u001a\u00020\u0015J%\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00028\u00012\u0006\u0010\u001d\u001a\u00028\u00012\b\b\u0002\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\u0002\u0010 J\u001a\u0010!\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\f2\u0006\u0010\"\u001a\u00020#J\u0019\u0010$\u001a\u0006\u0012\u0002\b\u00030%2\u0006\u0010&\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010'J\u0015\u0010(\u001a\u00020)2\u0006\u0010&\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010*J\u001d\u0010+\u001a\u00028\u00022\u0006\u0010,\u001a\u00028\u00002\u0006\u0010&\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010-J-\u0010.\u001a\u00020\u00152\u0006\u0010/\u001a\u00028\u00012\u0018\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\f\u00a2\u0006\u0002\u00100JC\u00101\u001a\u00020\u001526\u0010\n\u001a\u001c\u0012\u0018\b\u0001\u0012\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\f0\u0016\"\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\f\u00a2\u0006\u0002\u0010\u0017R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\n\u001a \u0012\u0004\u0012\u00028\u0001\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000RH\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00062\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00068V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0007\u00a8\u0006;"}, d2={"Lorg/molap/dataframe/WrappedDataFrame;", "R", "C", "V", "Lorg/molap/dataframe/ReMappedDataFrame;", "dataFrame", "Lorg/molap/dataframe/DataFrame;", "(Lorg/molap/dataframe/DataFrame;)V", "columnListener", "Lorg/molap/dataframe/WrappedDataFrame$ColumnListener;", "columns", "", "Lorg/molap/dataframe/WrappedDataFrame$Column;", "getDataFrame", "()Lorg/molap/dataframe/DataFrame;", "keys", "", "originalDataFrame", "getOriginalDataFrame", "setOriginalDataFrame", "addDerivedColumn", "", "", "([Lorg/molap/dataframe/WrappedDataFrame$Column;)V", "addOriginalColumn", "([Ljava/lang/Object;)V", "addOriginalColumns", "addRenamedColumn", "column", "name", "checkExists", "", "(Ljava/lang/Object;Ljava/lang/Object;Z)V", "getCalculatedColumnAt", "i", "", "getColumnClass", "Lkotlin/reflect/KClass;", "c", "(Ljava/lang/Object;)Lkotlin/reflect/KClass;", "getColumnName", "", "(Ljava/lang/Object;)Ljava/lang/String;", "getValueAt", "r", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "modifyColumn", "oldColumn", "(Ljava/lang/Object;Lorg/molap/dataframe/WrappedDataFrame$Column;)V", "removeDerivedColumn", "AbstractColumn", "Column", "ColumnEvent", "ColumnListener", "DataFrameColumn", "DerivedColumn", "InternalDataFrameColumn", "NamedTypedColumn", "SumColumn", "molap"})
public final class WrappedDataFrame<R, C, V>
extends ReMappedDataFrame<R, C, V> {
    private final List<C> keys;
    private final Map<C, Column<R, C, V>> columns;
    private final ColumnListener<R, C, V> columnListener;
    @NotNull
    private final DataFrame<R, C, V> dataFrame;

    @Override
    @NotNull
    public String getColumnName(C c) {
        Column<R, C, V> column = this.columns.get(c);
        Intrinsics.checkNotNull(column);
        return column.getColumnName();
    }

    @Override
    @NotNull
    public KClass<?> getColumnClass(C c) {
        Column<R, C, V> column = this.columns.get(c);
        return column != null ? column.getType(this) : Reflection.getOrCreateKotlinClass(Object.class);
    }

    @Override
    public V getValueAt(R r, C c) {
        Column<R, C, V> column;
        Column<R, C, V> column2 = column = this.columns.get(c);
        V v = column2 != null ? (V)column2.getValue(this, r) : null;
        Intrinsics.checkNotNull(v);
        return v;
    }

    public final void addOriginalColumns() {
        Iterable<C> iterable = this.dataFrame.columns();
        Intrinsics.checkNotNull(iterable);
        for (C column : iterable) {
            this.keys.add(column);
            this.columns.put(column, new InternalDataFrameColumn(this, column, null, 2, null));
        }
        this.invalidate();
        this.scheduleUpdate();
    }

    public final void addOriginalColumn(C ... columns) {
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        for (C column : columns) {
            this.keys.add(column);
            this.columns.put(column, new InternalDataFrameColumn(this, column, null, 2, null));
        }
        this.invalidate();
        this.scheduleUpdate();
    }

    public final void addRenamedColumn(C column, C name, boolean checkExists) {
        this.keys.add(name);
        this.columns.put(name, new InternalDataFrameColumn(this, name, column));
        this.invalidate();
        this.scheduleUpdate();
    }

    public static /* synthetic */ void addRenamedColumn$default(WrappedDataFrame wrappedDataFrame, Object object, Object object2, boolean bl, int n, Object object3) {
        if ((n & 4) != 0) {
            bl = true;
        }
        wrappedDataFrame.addRenamedColumn(object, object2, bl);
    }

    public final void addDerivedColumn(Column<R, C, V> ... columns) {
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        for (Column<R, C, V> column : columns) {
            this.keys.add(column.getKey());
            this.columns.put(column.getKey(), column);
            column.addColumnListener(this.columnListener);
        }
        this.invalidate();
        this.scheduleUpdate();
    }

    public final void removeDerivedColumn(Column<R, C, V> ... columns) {
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        for (Column<R, C, V> column : columns) {
            this.keys.remove(column.getKey());
            this.columns.remove(column.getKey());
            column.removeColumnListener(this.columnListener);
        }
        this.invalidate();
        this.scheduleUpdate();
    }

    @Override
    @NotNull
    public DataFrame<R, C, V> getOriginalDataFrame() {
        return this.dataFrame;
    }

    @Override
    public void setOriginalDataFrame(@NotNull DataFrame<R, C, V> originalDataFrame) {
        Intrinsics.checkNotNullParameter(originalDataFrame, (String)"originalDataFrame");
        super.setOriginalDataFrame(originalDataFrame);
    }

    @NotNull
    public final Column<?, ?, ?> getCalculatedColumnAt(int i) {
        Column<R, C, V> column = this.columns.get(this.keys.get(i));
        Intrinsics.checkNotNull(column);
        return column;
    }

    public final void modifyColumn(C oldColumn, @NotNull Column<R, C, V> column) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Column<R, C, V> column2 = this.columns.get(oldColumn);
        Intrinsics.checkNotNull(column2);
        column2.removeColumnListener(this.columnListener);
        this.keys.set(this.keys.indexOf(oldColumn), column.getKey());
        this.columns.put(oldColumn, column);
        this.columns.put(column.getKey(), column);
        column.addColumnListener(this.columnListener);
        this.invalidate();
        this.scheduleUpdate();
    }

    @NotNull
    public final DataFrame<R, C, V> getDataFrame() {
        return this.dataFrame;
    }

    public WrappedDataFrame(final @NotNull DataFrame<R, C, V> dataFrame) {
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        super(dataFrame, new ReMappedRecipe<R, C>(){

            @Override
            @NotNull
            public UniqueIndex<R> buildRowIndex() {
                return dataFrame.getRowIndex();
            }

            @Override
            @NotNull
            public UniqueIndex<C> buildColumnIndex() {
                return dataFrame.getColumnIndex();
            }
        });
        this.dataFrame = dataFrame;
        this.keys = new ArrayList();
        this.columns = new LinkedHashMap();
        this.columnListener = new ColumnListener<R, C, V>(this){
            final /* synthetic */ WrappedDataFrame this$0;

            public void columnChanged(@NotNull ColumnEvent<R, C, V> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                this.this$0.notifyDataFrameChanged(new DataFrameEvent<R, C>(event.getAffectedRows(), SetsKt.setOf(event.getAffectedColumn()), false));
            }
            {
                this.this$0 = this$0;
            }
        };
        ReMappedRecipe recipe2 = new ReMappedRecipe<R, C>(this){
            final /* synthetic */ WrappedDataFrame this$0;

            @NotNull
            public UniqueIndex<R> buildRowIndex() {
                return this.this$0.getDataFrame().getRowIndex();
            }

            @NotNull
            public UniqueIndex<C> buildColumnIndex() {
                return new DefaultUniqueIndex<K>(WrappedDataFrame.access$getKeys$p(this.this$0), false);
            }
            {
                this.this$0 = this$0;
            }
        };
        this.setRecipe(recipe2);
    }

    public static final /* synthetic */ List access$getKeys$p(WrappedDataFrame $this) {
        return $this.keys;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u0000*\u0004\b\u0003\u0010\u0001*\u0004\b\u0004\u0010\u0002*\u0004\b\u0005\u0010\u00032\u00020\u0004J\"\u0010\f\u001a\u00020\r2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u000fH&J&\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u0013H&J/\u0010\u0014\u001a\u00028\u00052\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u00132\u0006\u0010\u0015\u001a\u00028\u0003H&\u00a2\u0006\u0002\u0010\u0016J\"\u0010\u0017\u001a\u00020\r2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u000fH&R\u0012\u0010\u0005\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00028\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lorg/molap/dataframe/WrappedDataFrame$Column;", "R", "C", "V", "", "columnName", "", "getColumnName", "()Ljava/lang/String;", "key", "getKey", "()Ljava/lang/Object;", "addColumnListener", "", "listener", "Lorg/molap/dataframe/WrappedDataFrame$ColumnListener;", "getType", "Lkotlin/reflect/KClass;", "dataFrame", "Lorg/molap/dataframe/WrappedDataFrame;", "getValue", "r", "(Lorg/molap/dataframe/WrappedDataFrame;Ljava/lang/Object;)Ljava/lang/Object;", "removeColumnListener", "molap"})
    public static interface Column<R, C, V> {
        public C getKey();

        @NotNull
        public KClass<?> getType(@NotNull WrappedDataFrame<R, C, V> var1);

        @NotNull
        public String getColumnName();

        public V getValue(@NotNull WrappedDataFrame<R, C, V> var1, R var2);

        public void addColumnListener(@NotNull ColumnListener<R, C, V> var1);

        public void removeColumnListener(@NotNull ColumnListener<R, C, V> var1);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\u0004\b\u0003\u0010\u0001*\u0004\b\u0004\u0010\u0002*\u0004\b\u0005\u0010\u00032\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\"\u0010\u000f\u001a\u00020\u00102\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\bH\u0016J\"\u0010\u0012\u001a\u00020\u00102\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u0014H\u0004J\"\u0010\u0015\u001a\u00020\u00102\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\bH\u0016R3\u0010\u0006\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\b0\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR,\u0010\r\u001a \u0012\u001c\u0012\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\b0\u00070\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/molap/dataframe/WrappedDataFrame$AbstractColumn;", "R", "C", "V", "Lorg/molap/dataframe/WrappedDataFrame$Column;", "()V", "listeners", "", "Lorg/molap/dataframe/WrappedDataFrame$ColumnListener;", "getListeners", "()Ljava/util/List;", "listeners$delegate", "Lkotlin/Lazy;", "listernersDelegate", "Lkotlin/Lazy;", "addColumnListener", "", "listener", "notifyColumnChanged", "event", "Lorg/molap/dataframe/WrappedDataFrame$ColumnEvent;", "removeColumnListener", "molap"})
    public static abstract class AbstractColumn<R, C, V>
    implements Column<R, C, V> {
        private final Lazy<List<ColumnListener<R, C, V>>> listernersDelegate = LazyKt.lazy((Function0)listernersDelegate.1.INSTANCE);
        private final Lazy listeners$delegate = this.listernersDelegate;

        private final List<ColumnListener<R, C, V>> getListeners() {
            Lazy lazy = this.listeners$delegate;
            AbstractColumn abstractColumn = this;
            Object var3_3 = null;
            boolean bl = false;
            return (List)lazy.getValue();
        }

        @Override
        public void addColumnListener(@NotNull ColumnListener<R, C, V> listener) {
            Intrinsics.checkNotNullParameter(listener, (String)"listener");
            this.getListeners().add(listener);
        }

        @Override
        public void removeColumnListener(@NotNull ColumnListener<R, C, V> listener) {
            Intrinsics.checkNotNullParameter(listener, (String)"listener");
            this.getListeners().remove(listener);
        }

        protected final void notifyColumnChanged(@NotNull ColumnEvent<R, C, V> event) {
            Intrinsics.checkNotNullParameter(event, (String)"event");
            for (ColumnListener<R, C, V> listener : this.getListeners()) {
                listener.columnChanged(event);
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\u0004\b\u0003\u0010\u0001*\u0004\b\u0004\u0010\u00022\u0016\u0012\u0004\u0012\u0002H\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u0002H\u00020\u0003B\u0019\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a2\u0006\u0002\u0010\bJ(\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u00072\u001a\u0010\u000e\u001a\u0016\u0012\u0004\u0012\u00028\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00028\u00040\u000fH\u0016R\u0014\u0010\u0005\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0012\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/molap/dataframe/WrappedDataFrame$NamedTypedColumn;", "R", "V", "Lorg/molap/dataframe/WrappedDataFrame$AbstractColumn;", "", "columnName", "type", "Lkotlin/reflect/KClass;", "(Ljava/lang/String;Lkotlin/reflect/KClass;)V", "getColumnName", "()Ljava/lang/String;", "key", "getKey", "getType", "dataFrame", "Lorg/molap/dataframe/WrappedDataFrame;", "molap"})
    public static abstract class NamedTypedColumn<R, V>
    extends AbstractColumn<R, String, V> {
        private final KClass<?> type;
        @NotNull
        private final String columnName;

        @Override
        @NotNull
        public String getKey() {
            return this.getColumnName();
        }

        @Override
        @NotNull
        public KClass<?> getType(@NotNull WrappedDataFrame<R, String, V> dataFrame) {
            Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
            return this.type;
        }

        @Override
        @NotNull
        public String getColumnName() {
            return this.columnName;
        }

        public NamedTypedColumn(@NotNull String columnName, @NotNull KClass<?> type) {
            Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
            Intrinsics.checkNotNullParameter(type, (String)"type");
            this.columnName = columnName;
            this.type = type;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\u0004\b\u0003\u0010\u0001*\u0004\b\u0004\u0010\u0002*\u0004\b\u0005\u0010\u00032\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0004B\u0019\u0012\u0006\u0010\u0005\u001a\u00028\u0004\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a2\u0006\u0002\u0010\bJ\"\u0010\u0019\u001a\u00020\u001a2\u0018\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u0012H\u0016J&\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u00072\u0018\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u001eH\u0016J\"\u0010\u001f\u001a\u00020\u001a2\u0018\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u0012H\u0016J\b\u0010 \u001a\u00020\nH\u0016R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0005\u001a\u00028\u0004X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR3\u0010\u0010\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u00120\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R,\u0010\u0017\u001a \u0012\u001c\u0012\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u00120\u00110\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/molap/dataframe/WrappedDataFrame$DerivedColumn;", "R", "C", "V", "Lorg/molap/dataframe/WrappedDataFrame$Column;", "key", "type", "Lkotlin/reflect/KClass;", "(Ljava/lang/Object;Lkotlin/reflect/KClass;)V", "columnName", "", "getColumnName", "()Ljava/lang/String;", "getKey", "()Ljava/lang/Object;", "Ljava/lang/Object;", "listeners", "", "Lorg/molap/dataframe/WrappedDataFrame$ColumnListener;", "getListeners", "()Ljava/util/List;", "listeners$delegate", "Lkotlin/Lazy;", "listernersDelegate", "Lkotlin/Lazy;", "addColumnListener", "", "listener", "getType", "dataFrame", "Lorg/molap/dataframe/WrappedDataFrame;", "removeColumnListener", "toString", "molap"})
    public static abstract class DerivedColumn<R, C, V>
    implements Column<R, C, V> {
        private final KClass<?> type;
        private final Lazy<List<ColumnListener<R, C, V>>> listernersDelegate;
        private final Lazy listeners$delegate;
        private final C key;

        private final List<ColumnListener<R, C, V>> getListeners() {
            Lazy lazy = this.listeners$delegate;
            DerivedColumn derivedColumn = this;
            Object var3_3 = null;
            boolean bl = false;
            return (List)lazy.getValue();
        }

        @Override
        @NotNull
        public String getColumnName() {
            return String.valueOf(this.getKey());
        }

        @Override
        @NotNull
        public KClass<?> getType(@NotNull WrappedDataFrame<R, C, V> dataFrame) {
            Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
            return this.type;
        }

        @NotNull
        public String toString() {
            return String.valueOf(this.getKey());
        }

        @Override
        public void addColumnListener(@NotNull ColumnListener<R, C, V> listener) {
            Intrinsics.checkNotNullParameter(listener, (String)"listener");
            this.getListeners().add(listener);
        }

        @Override
        public void removeColumnListener(@NotNull ColumnListener<R, C, V> listener) {
            Intrinsics.checkNotNullParameter(listener, (String)"listener");
            this.getListeners().remove(listener);
        }

        @Override
        public C getKey() {
            return this.key;
        }

        public DerivedColumn(C key, @NotNull KClass<?> type) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            this.key = key;
            this.listernersDelegate = LazyKt.lazy((Function0)listernersDelegate.1.INSTANCE);
            this.listeners$delegate = this.listernersDelegate;
            this.type = type;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0003\u0010\u0001*\u0004\b\u0004\u0010\u0002*\u0004\b\u0005\u0010\u00032\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0004B!\u0012\u0006\u0010\u0005\u001a\u00028\u0004\u0012\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00040\u0007\"\u00028\u0004\u00a2\u0006\u0002\u0010\bJ/\u0010\n\u001a\u00028\u00052\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\f2\u0006\u0010\r\u001a\u00028\u0003H\u0016\u00a2\u0006\u0002\u0010\u000eR\u0018\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00040\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u000f"}, d2={"Lorg/molap/dataframe/WrappedDataFrame$SumColumn;", "R", "C", "V", "Lorg/molap/dataframe/WrappedDataFrame$DerivedColumn;", "column", "columns", "", "(Ljava/lang/Object;[Ljava/lang/Object;)V", "[Ljava/lang/Object;", "getValue", "dataFrame", "Lorg/molap/dataframe/WrappedDataFrame;", "r", "(Lorg/molap/dataframe/WrappedDataFrame;Ljava/lang/Object;)Ljava/lang/Object;", "molap"})
    public static final class SumColumn<R, C, V>
    extends DerivedColumn<R, C, V> {
        private final C[] columns;

        @Override
        public V getValue(@NotNull WrappedDataFrame<R, C, V> dataFrame, R r) {
            Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
            Number sum = null;
            DataFrame<R, C, V> orig = dataFrame.getOriginalDataFrame();
            for (C c : this.columns) {
                V value = orig.getValueAt(r, c);
                if (value == null || !(value instanceof Number)) continue;
                V n = value;
                sum = sum == null ? (Number)((Number)n) : (Number)(sum.doubleValue() + ((Number)n).doubleValue());
            }
            return (V)sum;
        }

        public SumColumn(C column, C ... columns) {
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            super(column, Reflection.getOrCreateKotlinClass(Number.class));
            this.columns = columns;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00028\u0001\u0012\b\b\u0002\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0004J\"\u0010\f\u001a\u00020\r2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u000fH\u0016J&\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0013H\u0016J/\u0010\u0014\u001a\u00028\u00022\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00132\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016J\"\u0010\u0017\u001a\u00020\r2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u000fH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u0002\u001a\u00028\u0001X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0010\u0010\u0003\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lorg/molap/dataframe/WrappedDataFrame$InternalDataFrameColumn;", "Lorg/molap/dataframe/WrappedDataFrame$Column;", "key", "sourceColumn", "(Lorg/molap/dataframe/WrappedDataFrame;Ljava/lang/Object;Ljava/lang/Object;)V", "columnName", "", "getColumnName", "()Ljava/lang/String;", "getKey", "()Ljava/lang/Object;", "Ljava/lang/Object;", "addColumnListener", "", "listener", "Lorg/molap/dataframe/WrappedDataFrame$ColumnListener;", "getType", "Lkotlin/reflect/KClass;", "dataFrame", "Lorg/molap/dataframe/WrappedDataFrame;", "getValue", "r", "(Lorg/molap/dataframe/WrappedDataFrame;Ljava/lang/Object;)Ljava/lang/Object;", "removeColumnListener", "molap"})
    public final class InternalDataFrameColumn
    implements Column<R, C, V> {
        private final C key;
        private final C sourceColumn;
        final /* synthetic */ WrappedDataFrame this$0;

        @Override
        @NotNull
        public KClass<?> getType(@NotNull WrappedDataFrame<R, C, V> dataFrame) {
            Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
            return this.this$0.getOriginalDataFrame().getColumnClass(this.sourceColumn);
        }

        @Override
        @NotNull
        public String getColumnName() {
            return String.valueOf(this.getKey());
        }

        @Override
        public V getValue(@NotNull WrappedDataFrame<R, C, V> dataFrame, R r) {
            Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
            return this.this$0.getOriginalDataFrame().getValueAt(r, this.sourceColumn);
        }

        @Override
        public void addColumnListener(@NotNull ColumnListener<R, C, V> listener) {
            Intrinsics.checkNotNullParameter(listener, (String)"listener");
        }

        @Override
        public void removeColumnListener(@NotNull ColumnListener<R, C, V> listener) {
            Intrinsics.checkNotNullParameter(listener, (String)"listener");
        }

        @Override
        public C getKey() {
            return this.key;
        }

        public InternalDataFrameColumn(WrappedDataFrame this$0, C key, C sourceColumn) {
            this.this$0 = this$0;
            this.key = key;
            this.sourceColumn = sourceColumn;
        }

        public /* synthetic */ InternalDataFrameColumn(WrappedDataFrame wrappedDataFrame, Object object, Object object2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                object2 = object;
            }
            this(wrappedDataFrame, object, object2);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0003\u0010\u0001*\u0004\b\u0004\u0010\u0002*\u0004\b\u0005\u0010\u00032\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0004B)\b\u0016\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0004\u00a2\u0006\u0002\u0010\bB/\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u0006\u0012\u0006\u0010\t\u001a\u00028\u0004\u0012\u0006\u0010\n\u001a\u00028\u0004\u00a2\u0006\u0002\u0010\u000bJ\"\u0010\u0013\u001a\u00020\u00142\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u0016H\u0016J&\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u0019H\u0016J/\u0010\u001a\u001a\u00028\u00052\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u00192\u0006\u0010\u001b\u001a\u00028\u0003H\u0016\u00a2\u0006\u0002\u0010\u001cJ\"\u0010\u001d\u001a\u00020\u00142\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u0016H\u0016R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u00028\u0004X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\t\u001a\u00028\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lorg/molap/dataframe/WrappedDataFrame$DataFrameColumn;", "R", "C", "V", "Lorg/molap/dataframe/WrappedDataFrame$Column;", "dataFrame", "Lorg/molap/dataframe/DataFrame;", "column", "(Lorg/molap/dataframe/DataFrame;Ljava/lang/Object;)V", "sourceColumn", "key", "(Lorg/molap/dataframe/DataFrame;Ljava/lang/Object;Ljava/lang/Object;)V", "columnName", "", "getColumnName", "()Ljava/lang/String;", "getKey", "()Ljava/lang/Object;", "Ljava/lang/Object;", "addColumnListener", "", "listener", "Lorg/molap/dataframe/WrappedDataFrame$ColumnListener;", "getType", "Lkotlin/reflect/KClass;", "Lorg/molap/dataframe/WrappedDataFrame;", "getValue", "r", "(Lorg/molap/dataframe/WrappedDataFrame;Ljava/lang/Object;)Ljava/lang/Object;", "removeColumnListener", "molap"})
    public static final class DataFrameColumn<R, C, V>
    implements Column<R, C, V> {
        private final DataFrame<R, C, V> dataFrame;
        private final C sourceColumn;
        private final C key;

        @Override
        @NotNull
        public KClass<?> getType(@NotNull WrappedDataFrame<R, C, V> dataFrame) {
            Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
            return this.dataFrame.getColumnClass(this.sourceColumn);
        }

        @Override
        @NotNull
        public String getColumnName() {
            return String.valueOf(this.getKey());
        }

        @Override
        public V getValue(@NotNull WrappedDataFrame<R, C, V> dataFrame, R r) {
            Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
            return this.dataFrame.getValueAt(r, this.sourceColumn);
        }

        @Override
        public void addColumnListener(@NotNull ColumnListener<R, C, V> listener) {
            Intrinsics.checkNotNullParameter(listener, (String)"listener");
        }

        @Override
        public void removeColumnListener(@NotNull ColumnListener<R, C, V> listener) {
            Intrinsics.checkNotNullParameter(listener, (String)"listener");
        }

        @Override
        public C getKey() {
            return this.key;
        }

        public DataFrameColumn(@NotNull DataFrame<R, C, V> dataFrame, C sourceColumn, C key) {
            Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
            this.dataFrame = dataFrame;
            this.sourceColumn = sourceColumn;
            this.key = key;
        }

        public DataFrameColumn(@NotNull DataFrame<R, C, V> dataFrame, C column) {
            Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
            this(dataFrame, column, column);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u0000*\u0004\b\u0003\u0010\u0001*\u0004\b\u0004\u0010\u0002*\u0004\b\u0005\u0010\u00032\u00020\u0004J\"\u0010\u0005\u001a\u00020\u00062\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\bH&\u00a8\u0006\t"}, d2={"Lorg/molap/dataframe/WrappedDataFrame$ColumnListener;", "R", "C", "V", "", "columnChanged", "", "event", "Lorg/molap/dataframe/WrappedDataFrame$ColumnEvent;", "molap"})
    public static interface ColumnListener<R, C, V> {
        public void columnChanged(@NotNull ColumnEvent<R, C, V> var1);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001c\n\u0002\b\b\u0018\u0000*\u0004\b\u0003\u0010\u0001*\u0004\b\u0004\u0010\u0002*\u0004\b\u0005\u0010\u00032\u00020\u0004B\u001b\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00030\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0004\u00a2\u0006\u0002\u0010\bR\u0013\u0010\u0007\u001a\u00028\u0004\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/molap/dataframe/WrappedDataFrame$ColumnEvent;", "R", "C", "V", "", "affectedRows", "", "affectedColumn", "(Ljava/lang/Iterable;Ljava/lang/Object;)V", "getAffectedColumn", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getAffectedRows", "()Ljava/lang/Iterable;", "molap"})
    public static final class ColumnEvent<R, C, V> {
        @NotNull
        private final Iterable<R> affectedRows;
        private final C affectedColumn;

        @NotNull
        public final Iterable<R> getAffectedRows() {
            return this.affectedRows;
        }

        public final C getAffectedColumn() {
            return this.affectedColumn;
        }

        public ColumnEvent(@NotNull Iterable<? extends R> affectedRows, C affectedColumn) {
            Intrinsics.checkNotNullParameter(affectedRows, (String)"affectedRows");
            this.affectedRows = affectedRows;
            this.affectedColumn = affectedColumn;
        }
    }
}

