/*
 * Decompiled with CFR 0.152.
 */
package org.molap.dataframe.rowmajor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.dataframe.AbstractMutableDataFrame;
import org.molap.dataframe.DataFrameEvent;
import org.molap.dataframe.rowmajor.RowMajorDataFrame;
import org.molap.index.DefaultUniqueIndex;
import org.molap.index.UniqueIndex;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00042\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0005:\b-./01234B\u0019\u0012\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00010\u0007\"\u00028\u0001\u00a2\u0006\u0002\u0010\bJ\u001d\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u001d\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0015\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u001d\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010 J\u001b\u0010!\u001a\b\u0012\u0002\b\u0003\u0018\u00010\"2\u0006\u0010#\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010$J\u0015\u0010%\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u001d\u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00028\u00002\u0006\u0010(\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aJ(\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000*2\u0018\u0010+\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020,H\u0016R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00010\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\fR\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame;", "R", "C", "V", "Lorg/molap/dataframe/AbstractMutableDataFrame;", "Lorg/molap/dataframe/rowmajor/RowMajorDataFrame;", "columns", "", "([Ljava/lang/Object;)V", "columnIndex", "Lorg/molap/index/UniqueIndex;", "getColumnIndex", "()Lorg/molap/index/UniqueIndex;", "lazRowIndex", "queryBuilder", "Lorg/molap/dataframe/rowmajor/RowMajorDataFrame$QueryBuilder;", "getQueryBuilder", "()Lorg/molap/dataframe/rowmajor/RowMajorDataFrame$QueryBuilder;", "rowIndex", "getRowIndex", "rows", "", "addAfterRow", "", "insertionPoint", "row", "(Ljava/lang/Object;Ljava/lang/Object;)V", "addBeforeRow", "addRow", "(Ljava/lang/Object;)V", "i", "", "(ILjava/lang/Object;)V", "getRowClass", "Lkotlin/reflect/KClass;", "r", "(Ljava/lang/Object;)Lkotlin/reflect/KClass;", "remove", "replaceRow", "oldRow", "newRow", "retrieve", "", "query", "Lorg/molap/dataframe/rowmajor/RowMajorDataFrame$Query;", "AbstractQuery", "And", "DefaultQueryBuilder", "Equal", "GreaterThan", "Or", "Overlap", "SmallerThan", "molap"})
public abstract class AbstractRowMajorDataFrame<R, C, V>
extends AbstractMutableDataFrame<R, C, V>
implements RowMajorDataFrame<R, C, V> {
    @NotNull
    private final UniqueIndex<C> columnIndex;
    private UniqueIndex<R> lazRowIndex;
    private final List<R> rows;
    @NotNull
    private final RowMajorDataFrame.QueryBuilder<R, C, V> queryBuilder;

    @Override
    @NotNull
    public UniqueIndex<C> getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    @NotNull
    public UniqueIndex<R> getRowIndex() {
        if (this.lazRowIndex == null) {
            this.lazRowIndex = new DefaultUniqueIndex((Iterable)this.rows, true);
        }
        UniqueIndex<R> uniqueIndex = this.lazRowIndex;
        Intrinsics.checkNotNull(uniqueIndex);
        return uniqueIndex;
    }

    @Override
    @Nullable
    public KClass<?> getRowClass(R r) {
        return Reflection.getOrCreateKotlinClass(Object.class);
    }

    @Override
    public void addRow(R row) {
        this.rows.add(row);
        this.lazRowIndex = null;
        this.notifyDataFrameChanged(new DataFrameEvent(CollectionsKt.listOf(row), null, false));
    }

    @Override
    public void replaceRow(R oldRow, R newRow) {
        this.rows.set(this.getRowIndex().getAddress(oldRow), newRow);
        this.lazRowIndex = null;
        this.notifyDataFrameChanged(new DataFrameEvent(CollectionsKt.listOf((Object[])new Object[]{oldRow, newRow}), null, false));
    }

    @Override
    public void addRow(int i, R row) {
        this.rows.add(i, row);
        this.lazRowIndex = null;
        this.notifyDataFrameChanged(new DataFrameEvent(CollectionsKt.listOf(row), null, false));
    }

    @Override
    public void addBeforeRow(R insertionPoint, R row) {
        this.rows.add(this.getRowAddress(insertionPoint), row);
        this.lazRowIndex = null;
        this.notifyDataFrameChanged(new DataFrameEvent(CollectionsKt.listOf(row), null, false));
    }

    @Override
    public void addAfterRow(R insertionPoint, R row) {
        this.rows.add(this.getRowAddress(insertionPoint) + 1, row);
        this.lazRowIndex = null;
        this.notifyDataFrameChanged(new DataFrameEvent(CollectionsKt.listOf(row), null, false));
    }

    @Override
    public void remove(R row) {
        this.rows.remove(this.getRowAddress(row));
        this.lazRowIndex = null;
        this.notifyDataFrameChanged(new DataFrameEvent(CollectionsKt.listOf(row), null, false));
    }

    @Override
    @NotNull
    public List<R> retrieve(@NotNull RowMajorDataFrame.Query<R, C, V> query) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        List result = new ArrayList();
        for (Object row : this.rows()) {
            if (!query.matches(row)) continue;
            result.add(row);
        }
        return result;
    }

    @Override
    @NotNull
    public RowMajorDataFrame.QueryBuilder<R, C, V> getQueryBuilder() {
        return this.queryBuilder;
    }

    public AbstractRowMajorDataFrame(C ... columns) {
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        this.columnIndex = new DefaultUniqueIndex<C>(Arrays.copyOf(columns, columns.length));
        this.rows = new ArrayList();
        this.queryBuilder = new DefaultQueryBuilder();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0086\u0004\u0018\u00002\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002JP\u0010\u0003\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0018\u00010\u00042\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00042\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004H\u0016J/\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00042\u0006\u0010\b\u001a\u00028\u00012\u0006\u0010\t\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\nJ/\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00042\u0006\u0010\b\u001a\u00028\u00012\u0006\u0010\t\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\nJ/\u0010\f\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00042\u0006\u0010\b\u001a\u00028\u00012\u0006\u0010\t\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\nJP\u0010\r\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0018\u00010\u00042\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00042\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004H\u0016J?\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00042\u0006\u0010\u000f\u001a\u00028\u00012\u0006\u0010\u0010\u001a\u00028\u00012\u0006\u0010\u0011\u001a\u00028\u00022\u0006\u0010\u0012\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\u0013J/\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00042\u0006\u0010\b\u001a\u00028\u00012\u0006\u0010\t\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\nJ/\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00042\u0006\u0010\b\u001a\u00028\u00012\u0006\u0010\t\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u0016"}, d2={"Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame$DefaultQueryBuilder;", "Lorg/molap/dataframe/rowmajor/RowMajorDataFrame$QueryBuilder;", "(Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame;)V", "and", "Lorg/molap/dataframe/rowmajor/RowMajorDataFrame$Query;", "q1", "q2", "equal", "column", "value", "(Ljava/lang/Object;Ljava/lang/Object;)Lorg/molap/dataframe/rowmajor/RowMajorDataFrame$Query;", "greaterThan", "greaterThanOrEqualTo", "or", "overlap", "start1", "end1", "start2", "end2", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Lorg/molap/dataframe/rowmajor/RowMajorDataFrame$Query;", "smallerThan", "smallerThanOrEqualTo", "molap"})
    public final class DefaultQueryBuilder
    implements RowMajorDataFrame.QueryBuilder<R, C, V> {
        @Override
        @NotNull
        public RowMajorDataFrame.Query<R, C, V> equal(C column, V value) {
            return new Equal(column, value);
        }

        @Override
        @NotNull
        public RowMajorDataFrame.Query<R, C, V> smallerThan(C column, V value) {
            return new SmallerThan(column, value, false);
        }

        @Override
        @NotNull
        public RowMajorDataFrame.Query<R, C, V> smallerThanOrEqualTo(C column, V value) {
            return new SmallerThan(column, value, true);
        }

        @Override
        @NotNull
        public RowMajorDataFrame.Query<R, C, V> greaterThan(C column, V value) {
            return new GreaterThan(column, value, false);
        }

        @Override
        @NotNull
        public RowMajorDataFrame.Query<R, C, V> greaterThanOrEqualTo(C column, V value) {
            return new GreaterThan(column, value, true);
        }

        @Override
        @NotNull
        public RowMajorDataFrame.Query<R, C, V> overlap(C start1, C end1, V start2, V end2) {
            return new Overlap(start1, end1, start2, end2);
        }

        @Override
        @Nullable
        public RowMajorDataFrame.Query<R, C, V> and(@NotNull RowMajorDataFrame.Query<R, C, V> q1, @NotNull RowMajorDataFrame.Query<R, C, V> q2) {
            Intrinsics.checkNotNullParameter(q1, (String)"q1");
            Intrinsics.checkNotNullParameter(q2, (String)"q2");
            return q1.and(q2);
        }

        @Override
        @Nullable
        public RowMajorDataFrame.Query<R, C, V> or(@NotNull RowMajorDataFrame.Query<R, C, V> q1, @NotNull RowMajorDataFrame.Query<R, C, V> q2) {
            Intrinsics.checkNotNullParameter(q1, (String)"q1");
            Intrinsics.checkNotNullParameter(q2, (String)"q2");
            return q1.or(q2);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u00a6\u0004\u0018\u00002\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0001H\u0016J/\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00012\u0006\u0010\u0006\u001a\u00028\u00012\u0006\u0010\u0007\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\bJ/\u0010\t\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00012\u0006\u0010\u0006\u001a\u00028\u00012\u0006\u0010\u0007\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\bJ/\u0010\n\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00012\u0006\u0010\u0006\u001a\u00028\u00012\u0006\u0010\u0007\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\bJ4\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0001H\u0016J/\u0010\f\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00012\u0006\u0010\u0006\u001a\u00028\u00012\u0006\u0010\u0007\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\bJ/\u0010\r\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00012\u0006\u0010\u0006\u001a\u00028\u00012\u0006\u0010\u0007\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\b\u00a8\u0006\u000e"}, d2={"Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame$AbstractQuery;", "Lorg/molap/dataframe/rowmajor/RowMajorDataFrame$Query;", "(Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame;)V", "and", "query", "equal", "column", "value", "(Ljava/lang/Object;Ljava/lang/Object;)Lorg/molap/dataframe/rowmajor/RowMajorDataFrame$Query;", "greaterThan", "greaterThanOrEqualTo", "or", "smallerThan", "smallerThanOrEqualTo", "molap"})
    public abstract class AbstractQuery
    implements RowMajorDataFrame.Query<R, C, V> {
        @Override
        @NotNull
        public RowMajorDataFrame.Query<R, C, V> equal(C column, V value) {
            return new Equal(column, value);
        }

        @Override
        @NotNull
        public RowMajorDataFrame.Query<R, C, V> smallerThan(C column, V value) {
            return new SmallerThan(column, value, false);
        }

        @Override
        @NotNull
        public RowMajorDataFrame.Query<R, C, V> smallerThanOrEqualTo(C column, V value) {
            return new SmallerThan(column, value, true);
        }

        @Override
        @NotNull
        public RowMajorDataFrame.Query<R, C, V> greaterThan(C column, V value) {
            return new GreaterThan(column, value, false);
        }

        @Override
        @NotNull
        public RowMajorDataFrame.Query<R, C, V> greaterThanOrEqualTo(C column, V value) {
            return new GreaterThan(column, value, true);
        }

        @Override
        @NotNull
        public RowMajorDataFrame.Query<R, C, V> and(@NotNull RowMajorDataFrame.Query<R, C, V> query) {
            Intrinsics.checkNotNullParameter(query, (String)"query");
            return new And(this, query);
        }

        @Override
        @NotNull
        public RowMajorDataFrame.Query<R, C, V> or(@NotNull RowMajorDataFrame.Query<R, C, V> query) {
            Intrinsics.checkNotNullParameter(query, (String)"query");
            return new Or(this, query);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00180\u0001R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0002B=\u00126\u0010\u0003\u001a\u001c\u0012\u0018\b\u0001\u0012\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00050\u0004\"\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000bR(\u0010\u0003\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame$And;", "Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame$AbstractQuery;", "Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame;", "queries", "", "Lorg/molap/dataframe/rowmajor/RowMajorDataFrame$Query;", "(Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame;[Lorg/molap/dataframe/rowmajor/RowMajorDataFrame$Query;)V", "[Lorg/molap/dataframe/rowmajor/RowMajorDataFrame$Query;", "matches", "", "row", "(Ljava/lang/Object;)Z", "molap"})
    public final class And
    extends AbstractQuery {
        private final RowMajorDataFrame.Query<R, C, V>[] queries;

        @Override
        public boolean matches(R row) {
            for (RowMajorDataFrame.Query query : this.queries) {
                if (query.matches(row)) continue;
                return false;
            }
            return true;
        }

        public And(RowMajorDataFrame.Query<R, C, V> ... queries) {
            Intrinsics.checkNotNullParameter(queries, (String)"queries");
            Collection $this$toTypedArray$iv = ArraysKt.toList((Object[])queries);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            RowMajorDataFrame.Query[] queryArray = thisCollection$iv.toArray(new RowMajorDataFrame.Query[0]);
            if (queryArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            this.queries = queryArray;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00180\u0001R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0002B=\u00126\u0010\u0003\u001a\u001c\u0012\u0018\b\u0001\u0012\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00050\u0004\"\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000bR(\u0010\u0003\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame$Or;", "Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame$AbstractQuery;", "Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame;", "queries", "", "Lorg/molap/dataframe/rowmajor/RowMajorDataFrame$Query;", "(Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame;[Lorg/molap/dataframe/rowmajor/RowMajorDataFrame$Query;)V", "[Lorg/molap/dataframe/rowmajor/RowMajorDataFrame$Query;", "matches", "", "row", "(Ljava/lang/Object;)Z", "molap"})
    public final class Or
    extends AbstractQuery {
        private final RowMajorDataFrame.Query<R, C, V>[] queries;

        @Override
        public boolean matches(R row) {
            for (RowMajorDataFrame.Query query : this.queries) {
                if (!query.matches(row)) continue;
                return true;
            }
            return false;
        }

        public Or(RowMajorDataFrame.Query<R, C, V> ... queries) {
            Intrinsics.checkNotNullParameter(queries, (String)"queries");
            Collection $this$toTypedArray$iv = ArraysKt.toList((Object[])queries);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            RowMajorDataFrame.Query[] queryArray = thisCollection$iv.toArray(new RowMajorDataFrame.Query[0]);
            if (queryArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            this.queries = queryArray;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00180\u0001R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u0012\u0006\u0010\u0004\u001a\u00028\u0002\u00a2\u0006\u0002\u0010\u0005J\u0015\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\nR\u0010\u0010\u0003\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0012\u0010\u0004\u001a\u0004\u0018\u00018\u0002X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame$Equal;", "Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame$AbstractQuery;", "Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame;", "column", "value", "(Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame;Ljava/lang/Object;Ljava/lang/Object;)V", "Ljava/lang/Object;", "matches", "", "row", "(Ljava/lang/Object;)Z", "molap"})
    public final class Equal
    extends AbstractQuery {
        private final V value;
        private final C column;

        @Override
        public boolean matches(R row) {
            return this.value == null ? AbstractRowMajorDataFrame.this.getValueAt(row, this.column) == null : Intrinsics.areEqual(this.value, AbstractRowMajorDataFrame.this.getValueAt(row, this.column));
        }

        public Equal(C column, V value) {
            this.column = column;
            this.value = value;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0086\u0004\u0018\u00002\u00180\u0001R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u0012\u0006\u0010\u0004\u001a\u00028\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000bR\u0010\u0010\u0003\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0012\u0010\u0004\u001a\u0004\u0018\u00018\u0002X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame$SmallerThan;", "Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame$AbstractQuery;", "Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame;", "column", "value", "valueInclusive", "", "(Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame;Ljava/lang/Object;Ljava/lang/Object;Z)V", "Ljava/lang/Object;", "matches", "row", "(Ljava/lang/Object;)Z", "molap"})
    public final class SmallerThan
    extends AbstractQuery {
        private final V value;
        private final boolean valueInclusive;
        private final C column;

        @Override
        public boolean matches(R row) {
            boolean bl;
            if (this.value == null || !(this.value instanceof Comparable)) {
                bl = false;
            } else {
                Object v = this.value;
                if (v == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Comparable<V>");
                }
                int compareTo = ((Comparable)v).compareTo(AbstractRowMajorDataFrame.this.getValueAt(row, this.column));
                bl = this.valueInclusive ? compareTo <= 0 : compareTo < 0;
            }
            return bl;
        }

        public SmallerThan(C column, V value, boolean valueInclusive) {
            this.column = column;
            this.value = value;
            this.valueInclusive = valueInclusive;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0086\u0004\u0018\u00002\u00180\u0001R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u0012\u0006\u0010\u0004\u001a\u00028\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000bR\u0010\u0010\u0003\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0012\u0010\u0004\u001a\u0004\u0018\u00018\u0002X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame$GreaterThan;", "Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame$AbstractQuery;", "Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame;", "column", "value", "valueInclusive", "", "(Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame;Ljava/lang/Object;Ljava/lang/Object;Z)V", "Ljava/lang/Object;", "matches", "row", "(Ljava/lang/Object;)Z", "molap"})
    public final class GreaterThan
    extends AbstractQuery {
        private final V value;
        private final boolean valueInclusive;
        private final C column;

        @Override
        public boolean matches(R row) {
            boolean bl;
            if (this.value == null || !(this.value instanceof Comparable)) {
                bl = false;
            } else {
                Object v = this.value;
                if (v == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Comparable<V>");
                }
                int compareTo = ((Comparable)v).compareTo(AbstractRowMajorDataFrame.this.getValueAt(row, this.column));
                bl = this.valueInclusive ? compareTo >= 0 : compareTo > 0;
            }
            return bl;
        }

        public GreaterThan(C column, V value, boolean valueInclusive) {
            this.column = column;
            this.value = value;
            this.valueInclusive = valueInclusive;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00180\u0001R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u0012\u0006\u0010\u0004\u001a\u00028\u0001\u0012\u0006\u0010\u0005\u001a\u00028\u0002\u0012\u0006\u0010\u0006\u001a\u00028\u0002\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\fR\u0010\u0010\u0004\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0012\u0010\u0006\u001a\u0004\u0018\u00018\u0002X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0010\u0010\u0003\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0012\u0010\u0005\u001a\u0004\u0018\u00018\u0002X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\r"}, d2={"Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame$Overlap;", "Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame$AbstractQuery;", "Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame;", "start1", "end1", "start2", "end2", "(Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "Ljava/lang/Object;", "matches", "", "row", "(Ljava/lang/Object;)Z", "molap"})
    public final class Overlap
    extends AbstractQuery {
        private final V start2;
        private final V end2;
        private final C start1;
        private final C end1;

        @Override
        public boolean matches(R row) {
            boolean bl;
            if (this.start2 == null || !(this.start2 instanceof Comparable) || this.end2 == null || !(this.end2 instanceof Comparable)) {
                bl = false;
            } else {
                Object v = AbstractRowMajorDataFrame.this.getValueAt(row, this.start1);
                if (v == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Comparable<V>");
                }
                Comparable s1 = (Comparable)v;
                Object e1 = AbstractRowMajorDataFrame.this.getValueAt(row, this.end1);
                Object v2 = this.start2;
                if (v2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Comparable<V>");
                }
                Comparable s2 = (Comparable)v2;
                Object e2 = this.end2;
                bl = s1.compareTo(e2) < 0 && s2.compareTo(e1) < 0;
            }
            return bl;
        }

        public Overlap(C start1, C end1, V start2, V end2) {
            this.start1 = start1;
            this.end1 = end1;
            this.start2 = start2;
            this.end2 = end2;
        }
    }
}

