/*
 * Decompiled with CFR 0.152.
 */
package org.molap.exporter;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.molap.dataframe.DataFrame;
import org.molap.exporter.DataFrameWriter;
import org.molap.exporter.DelimitedDataFrameWriter;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JA\u0010\u0003\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u0005\"\u0004\b\u0001\u0010\u0006\"\u0004\b\u0002\u0010\u00072\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u00070\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fJ2\u0010\r\u001a\u00020\u000e\"\u0004\b\u0000\u0010\u0005\"\u0004\b\u0001\u0010\u0006\"\u0004\b\u0002\u0010\u00072\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u00070\tJA\u0010\u000f\u001a\u00020\u000e\"\u0004\b\u0000\u0010\u0005\"\u0004\b\u0001\u0010\u0006\"\u0004\b\u0002\u0010\u00072\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u00070\t2\u0006\u0010\u0010\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0011\u00a8\u0006\u0012"}, d2={"Lorg/molap/exporter/DataFrameExporter;", "", "()V", "export", "", "R", "C", "V", "dataFrame", "Lorg/molap/dataframe/DataFrame;", "writer", "Lorg/molap/exporter/DataFrameWriter;", "export$molap", "exportCSV", "", "exportDelimited", "delimiter", "exportDelimited$molap", "molap"})
public final class DataFrameExporter {
    @NotNull
    public static final DataFrameExporter INSTANCE;

    @NotNull
    public final <R, C, V> String exportCSV(@NotNull DataFrame<R, C, V> dataFrame) {
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        return this.exportDelimited$molap(dataFrame, ",");
    }

    @NotNull
    public final <R, C, V> String exportDelimited$molap(@NotNull DataFrame<R, C, V> dataFrame, @NotNull String delimiter) {
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        Intrinsics.checkNotNullParameter((Object)delimiter, (String)"delimiter");
        String newLine = "\n";
        StringBuilder sb = new StringBuilder("\ufeff");
        DataFrameWriter writer = new DelimitedDataFrameWriter(sb, dataFrame.getColumnCount(), delimiter, newLine);
        this.export$molap(dataFrame, writer);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final <R, C, V> void export$molap(@NotNull DataFrame<R, C, V> dataFrame, @NotNull DataFrameWriter writer) {
        KClass<Object> value;
        int column;
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        writer.start();
        int n = 0;
        int n2 = dataFrame.getColumnCount();
        while (n < n2) {
            value = dataFrame.getColumnName(dataFrame.getColumnKey(column));
            writer.writeColumnName((String)value, column < dataFrame.getColumnCount() - 1);
            ++column;
        }
        writer.nextRow();
        if (writer.includeType()) {
            n2 = dataFrame.getColumnCount();
            for (column = 0; column < n2; ++column) {
                value = dataFrame.getColumnClass(dataFrame.getColumnKey(column));
                writer.writeType(value, column < dataFrame.getColumnCount() - 1);
            }
            writer.nextRow();
        }
        column = 0;
        n2 = dataFrame.getRowCount();
        while (column < n2) {
            void row;
            int value2 = 0;
            int n3 = dataFrame.getColumnCount();
            while (value2 < n3) {
                void column2;
                try {
                    Object value3 = null;
                    R rowKey = dataFrame.getRowKey((int)row);
                    C columnKey = dataFrame.getColumnKey((int)column2);
                    value3 = dataFrame.getValueAt(rowKey, columnKey);
                    writer.writeCell(value3, dataFrame, rowKey, columnKey);
                    writer.nextColumn(column2 < dataFrame.getColumnCount() - 1);
                }
                catch (Exception e) {
                    try {
                        e.printStackTrace();
                        writer.nextColumn(column2 < dataFrame.getColumnCount() - 1);
                    }
                    catch (Throwable throwable) {
                        writer.nextColumn(column2 < dataFrame.getColumnCount() - 1);
                        throw throwable;
                    }
                }
                ++column2;
            }
            writer.nextRow();
            ++row;
        }
        writer.close();
    }

    private DataFrameExporter() {
    }

    static {
        DataFrameExporter dataFrameExporter;
        INSTANCE = dataFrameExporter = new DataFrameExporter();
    }
}

