/*
 * Decompiled with CFR 0.152.
 */
package org.molap.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.index.AbstractUniqueIndex;
import org.molap.index.DefaultUniqueIndex$WhenMappings;
import org.molap.index.UniqueIndex;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0015\n\u0002\b\u0004\u0018\u0000 ,*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0002,-B\u001d\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0015\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0002\u0010\tB\u001b\b\u0016\u0012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\n\"\u00028\u0000\u00a2\u0006\u0002\u0010\u000bB#\b\u0016\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\n\"\u00028\u0000\u00a2\u0006\u0002\u0010\u000eB-\b\u0016\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010\u0012\u0016\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0012j\b\u0012\u0004\u0012\u00028\u0000`\u0013\u00a2\u0006\u0002\u0010\u0014B)\b\u0012\u0012\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00160\u0015\u0012\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010 J\u0015\u0010!\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\"J\u0015\u0010#\u001a\u00028\u00002\u0006\u0010$\u001a\u00020\u0016H\u0016\u00a2\u0006\u0002\u0010%J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000\u00102\u0006\u0010'\u001a\u00020\u0016H\u0016J\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000\u00102\u0006\u0010)\u001a\u00020*J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u0016J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000\u00102\u0006\u0010'\u001a\u00020\u0016H\u0016R\u001a\u0010\u0019\u001a\u000e\u0018\u00010\u001aR\b\u0012\u0004\u0012\u00028\u00000\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006."}, d2={"Lorg/molap/index/DefaultUniqueIndex;", "K", "Lorg/molap/index/AbstractUniqueIndex;", "keys", "", "includeNull", "", "(Ljava/lang/Iterable;Z)V", "", "(Ljava/util/List;)V", "", "([Ljava/lang/Object;)V", "duplicate", "Lorg/molap/index/UniqueIndex$Duplicate;", "(Lorg/molap/index/UniqueIndex$Duplicate;[Ljava/lang/Object;)V", "index", "Lorg/molap/index/UniqueIndex;", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "(Lorg/molap/index/UniqueIndex;Ljava/util/Comparator;)V", "", "", "list", "(Ljava/util/Map;Ljava/util/List;)V", "lazy", "Lorg/molap/index/DefaultUniqueIndex$Lazy;", "size", "getSize", "()I", "contains", "key", "(Ljava/lang/Object;)Z", "getAddress", "(Ljava/lang/Object;)I", "getKey", "i", "(I)Ljava/lang/Object;", "head", "count", "keepAddresses", "addresses", "", "tail", "Companion", "Lazy", "molap"})
public final class DefaultUniqueIndex<K>
extends AbstractUniqueIndex<K> {
    private final Lazy lazy;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public boolean contains(K key) {
        Lazy lazy = this.lazy;
        Intrinsics.checkNotNull((Object)lazy);
        Map map = lazy.getIndex();
        Intrinsics.checkNotNull(map);
        return map.containsKey(key);
    }

    @Override
    public int getAddress(K key) {
        Lazy lazy = this.lazy;
        Intrinsics.checkNotNull((Object)lazy);
        return lazy.getAddress(key);
    }

    @Override
    @NotNull
    public Iterable<K> keys() {
        Lazy lazy = this.lazy;
        Intrinsics.checkNotNull((Object)lazy);
        return lazy.getList();
    }

    public K getKey(int i) {
        if (i < 0 || i >= this.getSize()) {
            throw (Throwable)new RuntimeException("Key is out of range");
        }
        Lazy lazy = this.lazy;
        Intrinsics.checkNotNull((Object)lazy);
        List list = lazy.getList();
        Intrinsics.checkNotNull(list);
        return list.get(i);
    }

    public int getSize() {
        Lazy lazy = this.lazy;
        Intrinsics.checkNotNull((Object)lazy);
        return lazy.getSize();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public UniqueIndex<K> head(int count) {
        Map index = new HashMap(count);
        List list = new ArrayList();
        int n = 0;
        int n2 = count;
        while (n < n2) {
            void i;
            Lazy lazy = this.lazy;
            Intrinsics.checkNotNull((Object)lazy);
            List list2 = lazy.getList();
            Intrinsics.checkNotNull(list2);
            Object key = list2.get((int)i);
            int loc = this.getAddress(key);
            index.put(key, loc);
            list.add(key);
            ++i;
        }
        return new DefaultUniqueIndex<K>(index, list);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public UniqueIndex<K> tail(int count) {
        Map index = new HashMap(count);
        List list = new ArrayList();
        int n = 0;
        int n2 = count;
        while (n < n2) {
            void i;
            Lazy lazy = this.lazy;
            Intrinsics.checkNotNull((Object)lazy);
            List list2 = lazy.getList();
            Intrinsics.checkNotNull(list2);
            List list3 = this.lazy.getList();
            Intrinsics.checkNotNull(list3);
            Object key = list2.get(list3.size() - 1 - i);
            int loc = this.getAddress(key);
            index.put(key, loc);
            list.add(key);
            ++i;
        }
        return new DefaultUniqueIndex<K>(index, list);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final UniqueIndex<K> keepAddresses(@NotNull int[] addresses) {
        Intrinsics.checkNotNullParameter((Object)addresses, (String)"addresses");
        Map index = new HashMap(addresses.length);
        List list = new ArrayList();
        int n = 0;
        int n2 = addresses.length;
        while (n < n2) {
            void i;
            int address = addresses[i];
            Lazy lazy = this.lazy;
            Intrinsics.checkNotNull((Object)lazy);
            List list2 = lazy.getList();
            Intrinsics.checkNotNull(list2);
            Object key = list2.get(address);
            index.put(key, (int)i);
            list.add(key);
            ++i;
        }
        return new DefaultUniqueIndex<K>(index, list);
    }

    public DefaultUniqueIndex(@NotNull Iterable<? extends K> keys2, boolean includeNull) {
        Intrinsics.checkNotNullParameter(keys2, (String)"keys");
        final Map index = new HashMap();
        final List list = new ArrayList();
        int i = 0;
        for (K key : keys2) {
            if (!includeNull && key == null || index.containsKey(key)) continue;
            index.put(key, i);
            list.add(key);
            ++i;
        }
        this.lazy = new Lazy(){

            @Override
            @NotNull
            protected Map<K, Integer> createIndex() {
                return index;
            }

            @Override
            @NotNull
            protected List<K> createList() {
                return list;
            }
        };
    }

    public DefaultUniqueIndex(final @NotNull List<K> keys2) {
        Intrinsics.checkNotNullParameter(keys2, (String)"keys");
        this.lazy = new Lazy(){

            @Override
            @NotNull
            protected Map<K, Integer> createIndex() {
                Map index = new HashMap(keys2.size());
                int i = 0;
                for (Object key : keys2) {
                    if (index.containsKey(key)) continue;
                    index.put(key, i);
                    ++i;
                }
                return index;
            }

            @Override
            @NotNull
            protected List<K> createList() {
                return keys2;
            }
        };
    }

    public DefaultUniqueIndex(K ... keys2) {
        Intrinsics.checkNotNullParameter(keys2, (String)"keys");
        this(UniqueIndex.Duplicate.UseFirstWarn, Arrays.copyOf(keys2, keys2.length));
    }

    /*
     * WARNING - void declaration
     */
    public DefaultUniqueIndex(@NotNull UniqueIndex.Duplicate duplicate, K ... keys2) {
        Intrinsics.checkNotNullParameter((Object)((Object)duplicate), (String)"duplicate");
        Intrinsics.checkNotNullParameter(keys2, (String)"keys");
        final Map index = new HashMap(keys2.length);
        final List list = new ArrayList();
        int n = 0;
        int n2 = keys2.length;
        while (n < n2) {
            void i;
            K key = keys2[i];
            if (!index.containsKey(key)) {
                index.put(key, (int)i);
                list.add(key);
            } else {
                switch (DefaultUniqueIndex$WhenMappings.$EnumSwitchMapping$0[duplicate.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        try {
                            throw (Throwable)new IllegalStateException("Index not unique for value " + key + " (address=" + (int)i + ')');
                        }
                        catch (IllegalStateException illegalStateException) {
                            break;
                        }
                    }
                    case 3: {
                        index.put(key, (int)i);
                        list.remove(key);
                        list.add(key);
                        String string = "Index not unique for value " + key + " (address=" + (int)i + "): will use last";
                        boolean bl = false;
                        System.out.println((Object)string);
                        break;
                    }
                    case 4: {
                        index.put(key, (int)i);
                        list.remove(key);
                        list.add(key);
                        String string = "Index not unique for value " + key + " (address=" + (int)i + "): will remove first";
                        boolean bl = false;
                        System.out.println((Object)string);
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 6: {
                        throw (Throwable)new IllegalStateException("Index not unique for value " + key + " (address=" + (int)i + ')');
                    }
                }
            }
            ++i;
        }
        this.lazy = new Lazy(){

            @Override
            @NotNull
            protected Map<K, Integer> createIndex() {
                return index;
            }

            @Override
            @NotNull
            protected List<K> createList() {
                return list;
            }
        };
    }

    public DefaultUniqueIndex(final @NotNull UniqueIndex<K> index, final @NotNull Comparator<K> comparator) {
        Intrinsics.checkNotNullParameter(index, (String)"index");
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        this.lazy = new Lazy(){

            @Override
            @NotNull
            protected Map<K, Integer> createIndex() {
                HashMap thisindex = new HashMap(index.getSize());
                UniqueIndex uniqueIndex = index;
                Intrinsics.checkNotNull((Object)uniqueIndex);
                Iterable iterable = uniqueIndex.keys();
                Intrinsics.checkNotNull((Object)iterable);
                for (Object key : iterable) {
                    thisindex.put(key, -1);
                }
                return thisindex;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected void populateIndex(@NotNull Map<K, Integer> index2) {
                Intrinsics.checkNotNullParameter(index2, (String)"index");
                List list = this.getList();
                int n = 0;
                List list2 = list;
                Intrinsics.checkNotNull(list2);
                int n2 = ((Collection)list2).size();
                while (n < n2) {
                    void i;
                    Object key = list.get((int)i);
                    index2.put(key, (int)i);
                    ++i;
                }
            }

            @Override
            @NotNull
            protected List<K> createList() {
                List list = new ArrayList();
                Iterable iterable = index.keys();
                Intrinsics.checkNotNull((Object)iterable);
                for (Object key : iterable) {
                    list.add(key);
                }
                CollectionsKt.sortWith((List)list, (Comparator)comparator);
                return list;
            }
        };
    }

    private DefaultUniqueIndex(Map<K, Integer> index, final List<K> list) {
        final Map<K, Integer> thisindex = index;
        this.lazy = new Lazy(){

            @Override
            @NotNull
            protected Map<K, Integer> createIndex() {
                return thisindex;
            }

            @Override
            @NotNull
            protected List<K> createList() {
                return list;
            }
        };
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\b\u00a2\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\u0004H$J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fH$J\u0013\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001eJ\u001c\u0010\u001f\u001a\u00020 2\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\u0004H\u0014R'\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R#\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\u00040\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR!\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\t\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\rR\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006!"}, d2={"Lorg/molap/index/DefaultUniqueIndex$Lazy;", "", "(Lorg/molap/index/DefaultUniqueIndex;)V", "index", "", "", "getIndex", "()Ljava/util/Map;", "index$delegate", "Lkotlin/Lazy;", "indexDelegate", "Lkotlin/Lazy;", "getIndexDelegate", "()Lkotlin/Lazy;", "list", "", "getList", "()Ljava/util/List;", "list$delegate", "listDelegate", "getListDelegate", "populated", "", "size", "getSize", "()I", "createIndex", "createList", "getAddress", "key", "(Ljava/lang/Object;)I", "populateIndex", "", "molap"})
    private abstract class Lazy {
        @NotNull
        private final kotlin.Lazy<Map<K, Integer>> indexDelegate = LazyKt.lazy((Function0)new Function0<Map<K, Integer>>(this){
            final /* synthetic */ Lazy this$0;

            @NotNull
            public final Map<K, Integer> invoke() {
                return this.this$0.createIndex();
            }
            {
                this.this$0 = lazy;
                super(0);
            }
        });
        @NotNull
        private final kotlin.Lazy index$delegate = this.indexDelegate;
        @NotNull
        private final kotlin.Lazy<List<K>> listDelegate = LazyKt.lazy((Function0)new Function0<List<K>>(this){
            final /* synthetic */ Lazy this$0;

            @NotNull
            public final List<K> invoke() {
                return this.this$0.createList();
            }
            {
                this.this$0 = lazy;
                super(0);
            }
        });
        @NotNull
        private final kotlin.Lazy list$delegate = this.listDelegate;
        private boolean populated;

        @NotNull
        public final kotlin.Lazy<Map<K, Integer>> getIndexDelegate() {
            return this.indexDelegate;
        }

        @NotNull
        public final Map<K, Integer> getIndex() {
            kotlin.Lazy lazy = this.index$delegate;
            Lazy lazy2 = this;
            Object var3_3 = null;
            boolean bl = false;
            return (Map)lazy.getValue();
        }

        @NotNull
        public final kotlin.Lazy<List<K>> getListDelegate() {
            return this.listDelegate;
        }

        @NotNull
        public final List<K> getList() {
            kotlin.Lazy lazy = this.list$delegate;
            Lazy lazy2 = this;
            Object var3_3 = null;
            boolean bl = false;
            return (List)lazy.getValue();
        }

        public final int getAddress(K key) {
            Integer i;
            Map index = this.getIndex();
            if (!this.populated) {
                this.populateIndex(index);
                this.populated = true;
            }
            if ((i = index.get(key)) != null) {
                return i;
            }
            throw (Throwable)new RuntimeException("Illegal key");
        }

        public final int getSize() {
            return this.getList().size();
        }

        @NotNull
        protected abstract Map<K, Integer> createIndex();

        @NotNull
        protected abstract List<K> createList();

        protected void populateIndex(@NotNull Map<K, Integer> index) {
            Intrinsics.checkNotNullParameter(index, (String)"index");
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0003\u001a\n\u0012\u0004\u0012\u0002H\u0005\u0018\u00010\u0004\"\u0004\b\u0001\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/molap/index/DefaultUniqueIndex$Companion;", "", "()V", "fromArray", "Lorg/molap/index/DefaultUniqueIndex;", "K", "keys", "", "([Ljava/lang/Object;)Lorg/molap/index/DefaultUniqueIndex;", "molap"})
    public static final class Companion {
        @Nullable
        public final <K> DefaultUniqueIndex<K> fromArray(@NotNull K[] keys2) {
            Intrinsics.checkNotNullParameter(keys2, (String)"keys");
            return new DefaultUniqueIndex<K>(UniqueIndex.Duplicate.UseFirstWarn, Arrays.copyOf(keys2, keys2.length));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

