/*
 * Decompiled with CFR 0.152.
 */
package org.molap.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.network.AdjacencyList;
import org.molap.network.DirectedLink;
import org.molap.network.Graph;
import org.molap.network.Link;
import org.molap.network.SimpleGraph;
import org.molap.network.TermForm;
import org.molap.network.UndirectedLink;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0016\u0018\u0000 3*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003:\u000534567B=\u0012\u001a\b\u0002\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00060\u0005\u0012\u001a\b\u0002\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b0\u0005\u00a2\u0006\u0002\u0010\tJ!\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00062\u0006\u0010\u001e\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010\u001fJ'\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00028\u00002\u0006\u0010#\u001a\u00028\u00002\b\u0010$\u001a\u0004\u0018\u00018\u0001H\u0004\u00a2\u0006\u0002\u0010%J\u0015\u0010&\u001a\u00028\u00002\u0006\u0010'\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010(J\u001d\u0010)\u001a\u00028\u00012\u0006\u0010\"\u001a\u00028\u00002\u0006\u0010#\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010*J\u001b\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u00122\u0006\u0010+\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010,J\u001b\u0010-\u001a\b\u0012\u0004\u0012\u00028\u00000\u00122\u0006\u0010+\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010,J\u0015\u0010.\u001a\u00028\u00002\u0006\u0010'\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010(J\u001d\u0010/\u001a\u00028\u00002\u0006\u0010'\u001a\u00028\u00012\u0006\u00100\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010*J\b\u00101\u001a\u000202H\u0016R)\u0010\n\u001a\u001a\u0012\u0004\u0012\u00028\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR#\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R!\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00010\u00128VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0014R)\u0010\u0018\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u0019\u0012\u0004\u0012\u00028\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\rR)\u0010\u001b\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00060\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\r\u00a8\u00068"}, d2={"Lorg/molap/network/SimpleGraph;", "V", "E", "Lorg/molap/network/Graph;", "nodes", "", "Lorg/molap/network/SimpleGraph$Node;", "edges", "Lorg/molap/network/SimpleGraph$Edge;", "(Ljava/util/Collection;Ljava/util/Collection;)V", "edgeToE", "", "getEdgeToE", "()Ljava/util/Map;", "", "getEdges", "()Ljava/util/List;", "links", "", "getLinks", "()Ljava/lang/Iterable;", "links$delegate", "Lkotlin/Lazy;", "getNodes", "nodesToE", "Lorg/molap/network/Link;", "getNodesToE", "vertices", "getVertices", "addNode", "value", "(Ljava/lang/Object;)Lorg/molap/network/SimpleGraph$Node;", "addUndirectedEdge", "", "n1", "n2", "label", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "getFrom", "link", "(Ljava/lang/Object;)Ljava/lang/Object;", "getLink", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "n", "(Ljava/lang/Object;)Ljava/lang/Iterable;", "getNeighbors", "getTo", "target", "node", "toString", "", "Companion", "DirectedEdge", "Edge", "Node", "UndirectedEdge", "molap"})
public class SimpleGraph<V, E>
implements Graph<V, E> {
    @NotNull
    private final Map<V, Node<V, E>> vertices;
    @NotNull
    private final List<Edge<V, E>> edges;
    @NotNull
    private final Map<E, Edge<V, E>> edgeToE;
    @NotNull
    private final Map<Link<V, V>, E> nodesToE;
    @NotNull
    private final Lazy links$delegate;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Map<V, Node<V, E>> getVertices() {
        return this.vertices;
    }

    @NotNull
    public final List<Edge<V, E>> getEdges() {
        return this.edges;
    }

    @NotNull
    public final Map<E, Edge<V, E>> getEdgeToE() {
        return this.edgeToE;
    }

    @NotNull
    public final Map<Link<V, V>, E> getNodesToE() {
        return this.nodesToE;
    }

    @Override
    @NotNull
    public Iterable<V> getNodes() {
        return this.vertices.keySet();
    }

    @Override
    @NotNull
    public Iterable<E> getLinks() {
        Lazy lazy = this.links$delegate;
        SimpleGraph simpleGraph = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Iterable)lazy.getValue();
    }

    @Override
    public V target(E link, V node) {
        Edge<V, E> edge = this.edgeToE.get(link);
        Intrinsics.checkNotNull(edge);
        Node<V, E> node2 = this.vertices.get(node);
        Intrinsics.checkNotNull(node2);
        Node<V, E> node3 = edge.target(node2);
        Intrinsics.checkNotNull(node3);
        return node3.getValue();
    }

    @Override
    public V getFrom(E link) {
        Edge<V, E> edge = this.edgeToE.get(link);
        Intrinsics.checkNotNull(edge);
        return edge.getN1().getValue();
    }

    @Override
    public V getTo(E link) {
        Edge<V, E> edge = this.edgeToE.get(link);
        Intrinsics.checkNotNull(edge);
        return edge.getN2().getValue();
    }

    @Override
    public E getLink(V n1, V n2) {
        E e = this.nodesToE.get(new UndirectedLink<V, V>(n1, n2));
        Intrinsics.checkNotNull(e);
        return e;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterable<E> getLinks(V n) {
        void $this$mapTo$iv$iv;
        Node<V, E> node = this.vertices.get(n);
        Intrinsics.checkNotNull(node);
        Iterable $this$map$iv = node.getEdges();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object l;
            void it;
            Edge edge = (Edge)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it.getLabel());
            collection.add(l);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterable<V> getNeighbors(V n) {
        void $this$mapTo$iv$iv;
        Node<V, E> node = this.vertices.get(n);
        Intrinsics.checkNotNull(node);
        Iterable $this$map$iv = node.neighbors();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Node node2 = (Node)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object v = it.getValue();
            collection.add(v);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        Object object;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.vertices.values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block6: {
                Node node = (Node)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$all$iv = this.edges;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Edge it = (Edge)element$iv;
                        boolean bl3 = false;
                        if (Intrinsics.areEqual(it.getN1(), (Object)node) ^ true && Intrinsics.areEqual(it.getN2(), (Object)node) ^ true) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List standaloneNodes = (List)destination$iv$iv;
        Iterable $this$map$iv = this.edges;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Edge bl2 = (Edge)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            object = it.toString();
            collection.add(object);
        }
        $this$map$iv = standaloneNodes;
        collection = (List)destination$iv$iv2;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Node it = (Node)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            String string = it.toString();
            object.add(string);
        }
        object = (List)destination$iv$iv2;
        String s = CollectionsKt.joinToString$default((Iterable)CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)object)), null, null, null, (int)0, null, null, (int)63, null);
        return '[' + s + ']';
    }

    @NotNull
    protected final Node<V, E> addNode(V value) {
        Node node = new Node(value);
        this.vertices.put(value, node);
        return node;
    }

    protected final void addUndirectedEdge(V n1, V n2, @Nullable E label) {
        block5: {
            block4: {
                Map<Node<V, E>, Node<Node<V, E>, E>> map = this.vertices;
                boolean bl = false;
                Map<Node<V, E>, Node<Node<V, E>, E>> map2 = map;
                boolean bl2 = false;
                if (!map2.containsKey(n1)) break block4;
                map = this.vertices;
                bl = false;
                map2 = map;
                bl2 = false;
                if (map2.containsKey(n2)) break block5;
            }
            throw (Throwable)new IllegalStateException("Expected '" + n1 + "' and '" + n2 + "' nodes to exist in graph");
        }
        Node<V, E> node = this.vertices.get(n1);
        Intrinsics.checkNotNull(node);
        Node<V, E> node2 = this.vertices.get(n2);
        Intrinsics.checkNotNull(node2);
        UndirectedEdge<V, E> edge = new UndirectedEdge<V, E>(node, node2, label);
        this.edges.add(edge);
        Node<V, E> node3 = this.vertices.get(n1);
        Intrinsics.checkNotNull(node3);
        node3.getEdges().add(edge);
        Node<V, E> node4 = this.vertices.get(n2);
        Intrinsics.checkNotNull(node4);
        node4.getEdges().add(edge);
        if (label != null) {
            this.edgeToE.put(label, edge);
            this.nodesToE.put(new UndirectedLink<V, V>(n1, n2), label);
        }
    }

    /*
     * WARNING - void declaration
     */
    public SimpleGraph(@NotNull Collection<Node<V, E>> nodes, @NotNull Collection<? extends Edge<V, E>> edges) {
        Pair pair;
        Edge it;
        Collection<Pair> collection;
        Iterable $this$mapTo$iv$iv;
        void $this$map$iv322;
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        Intrinsics.checkNotNullParameter(edges, (String)"edges");
        Iterable iterable = nodes;
        SimpleGraph simpleGraph = this;
        boolean $i$f$map = false;
        void var5_11 = $this$map$iv322;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv322, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Node node = (Node)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            pair = new Pair(((Node)((Object)it)).getValue(), (Object)it);
            collection.add(pair);
        }
        collection = (List)destination$iv$iv;
        boolean $this$map$iv322 = false;
        simpleGraph.vertices = MapsKt.toMap((Iterable)collection, (Map)new LinkedHashMap());
        this.edges = CollectionsKt.toMutableList(edges);
        Iterable $this$map$iv322 = edges;
        simpleGraph = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv322;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv322, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Edge)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Object l = it.getLabel();
            Intrinsics.checkNotNull(l);
            pair = new Pair(l, (Object)it);
            collection.add(pair);
        }
        collection = (List)destination$iv$iv;
        boolean $this$map$iv22 = false;
        simpleGraph.edgeToE = MapsKt.toMap((Iterable)collection, (Map)new LinkedHashMap());
        Iterable $this$map$iv22 = edges;
        simpleGraph = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv22;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv22, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Edge)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            DirectedLink directedLink = new DirectedLink(it.getN1().getValue(), it.getN2().getValue());
            Object l = it.getLabel();
            Intrinsics.checkNotNull(l);
            pair = new Pair(directedLink, l);
            collection.add(pair);
        }
        collection = (List)destination$iv$iv;
        boolean bl = false;
        simpleGraph.nodesToE = MapsKt.toMap((Iterable)collection, (Map)new LinkedHashMap());
        this.links$delegate = LazyKt.lazy((Function0)new Function0<List<? extends E>>(this){
            final /* synthetic */ SimpleGraph this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<E> invoke() {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = this.this$0.getEdges();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    L l;
                    void it;
                    Edge edge = (Edge)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull(it.getLabel());
                    collection.add(l);
                }
                return (List)destination$iv$iv;
            }
            {
                this.this$0 = simpleGraph;
                super(0);
            }
        });
    }

    public /* synthetic */ SimpleGraph(Collection collection, Collection collection2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            collection = CollectionsKt.emptyList();
        }
        if ((n & 2) != 0) {
            collection2 = CollectionsKt.emptyList();
        }
        this(collection, collection2);
    }

    public SimpleGraph() {
        this(null, null, 3, null);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0002\u0010\u0001*\u0004\b\u0003\u0010\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0002\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u000e\u001a\u00028\u0002H\u00c6\u0003\u00a2\u0006\u0002\u0010\fJ$\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u00002\b\b\u0002\u0010\u0004\u001a\u00028\u0002H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\u0018\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u00000\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0016R#\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u00028\u0002\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Lorg/molap/network/SimpleGraph$Node;", "V", "L", "", "value", "(Ljava/lang/Object;)V", "edges", "", "Lorg/molap/network/SimpleGraph$Edge;", "getEdges", "()Ljava/util/List;", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "component1", "copy", "(Ljava/lang/Object;)Lorg/molap/network/SimpleGraph$Node;", "equals", "", "other", "hashCode", "", "neighbors", "", "toString", "", "molap"})
    public static final class Node<V, L> {
        @NotNull
        private final List<Edge<V, L>> edges;
        private final V value;

        @NotNull
        public final List<Edge<V, L>> getEdges() {
            return this.edges;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Node<V, L>> neighbors() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.edges;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Node node;
                void edge;
                Edge edge2 = (Edge)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(edge.target(this));
                collection.add(node);
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public String toString() {
            return String.valueOf(this.value);
        }

        public final V getValue() {
            return this.value;
        }

        public Node(V value) {
            this.value = value;
            this.edges = new ArrayList();
        }

        public final V component1() {
            return this.value;
        }

        @NotNull
        public final Node<V, L> copy(V value) {
            return new Node<V, L>(value);
        }

        public static /* synthetic */ Node copy$default(Node node, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                object = node.value;
            }
            return node.copy(object);
        }

        public int hashCode() {
            V v = this.value;
            return v != null ? v.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Node)) break block3;
                    Node node = (Node)object;
                    if (!Intrinsics.areEqual(this.value, node.value)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\bf\u0018\u0000*\u0004\b\u0002\u0010\u0001*\u0004\b\u0003\u0010\u00022\u00020\u0003J\u001c\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0000H\u0016J*\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0018\u00010\b2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\bH&R\u0014\u0010\u0004\u001a\u0004\u0018\u00018\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0012"}, d2={"Lorg/molap/network/SimpleGraph$Edge;", "V", "L", "", "label", "getLabel", "()Ljava/lang/Object;", "n1", "Lorg/molap/network/SimpleGraph$Node;", "getN1", "()Lorg/molap/network/SimpleGraph$Node;", "n2", "getN2", "equivalentTo", "", "other", "target", "node", "molap"})
    public static interface Edge<V, L> {
        @NotNull
        public Node<V, L> getN1();

        @NotNull
        public Node<V, L> getN2();

        @Nullable
        public L getLabel();

        @Nullable
        public Node<V, L> target(@NotNull Node<V, L> var1);

        public boolean equivalentTo(@NotNull Edge<V, L> var1);

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            public static <V, L> boolean equivalentTo(@NotNull Edge<V, L> $this, @NotNull Edge<V, L> other) {
                Intrinsics.checkNotNullParameter(other, (String)"other");
                return Intrinsics.areEqual($this.getN1(), other.getN1()) && Intrinsics.areEqual($this.getN2(), other.getN2()) || Intrinsics.areEqual($this.getN1(), other.getN2()) && Intrinsics.areEqual($this.getN2(), other.getN1());
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0002\u0010\u0001*\u0004\b\u0003\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B7\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00018\u0003\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0005H\u00c6\u0003J\u0015\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0005H\u00c6\u0003J\u0010\u0010\u0011\u001a\u0004\u0018\u00018\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\nJR\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u00002\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u00052\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00018\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0013J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J*\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0018\u00010\u00052\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0005H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0018\u0010\u0007\u001a\u0004\u0018\u00018\u0003X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u001e"}, d2={"Lorg/molap/network/SimpleGraph$UndirectedEdge;", "V", "L", "Lorg/molap/network/SimpleGraph$Edge;", "n1", "Lorg/molap/network/SimpleGraph$Node;", "n2", "label", "(Lorg/molap/network/SimpleGraph$Node;Lorg/molap/network/SimpleGraph$Node;Ljava/lang/Object;)V", "getLabel", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getN1", "()Lorg/molap/network/SimpleGraph$Node;", "getN2", "component1", "component2", "component3", "copy", "(Lorg/molap/network/SimpleGraph$Node;Lorg/molap/network/SimpleGraph$Node;Ljava/lang/Object;)Lorg/molap/network/SimpleGraph$UndirectedEdge;", "equals", "", "other", "", "hashCode", "", "target", "node", "toString", "", "molap"})
    public static final class UndirectedEdge<V, L>
    implements Edge<V, L> {
        @NotNull
        private final Node<V, L> n1;
        @NotNull
        private final Node<V, L> n2;
        @Nullable
        private final L label;

        @Override
        @Nullable
        public Node<V, L> target(@NotNull Node<V, L> node) {
            Intrinsics.checkNotNullParameter(node, (String)"node");
            return Intrinsics.areEqual(this.getN1(), node) ? this.getN2() : (Intrinsics.areEqual(this.getN2(), node) ? this.getN1() : null);
        }

        @NotNull
        public String toString() {
            return this.getN1() + '-' + this.getN2() + (this.getLabel() == null ? "" : "" + '/' + this.getLabel());
        }

        @Override
        @NotNull
        public Node<V, L> getN1() {
            return this.n1;
        }

        @Override
        @NotNull
        public Node<V, L> getN2() {
            return this.n2;
        }

        @Override
        @Nullable
        public L getLabel() {
            return this.label;
        }

        public UndirectedEdge(@NotNull Node<V, L> n1, @NotNull Node<V, L> n2, @Nullable L label) {
            Intrinsics.checkNotNullParameter(n1, (String)"n1");
            Intrinsics.checkNotNullParameter(n2, (String)"n2");
            this.n1 = n1;
            this.n2 = n2;
            this.label = label;
        }

        @Override
        public boolean equivalentTo(@NotNull Edge<V, L> other) {
            Intrinsics.checkNotNullParameter(other, (String)"other");
            return Edge.DefaultImpls.equivalentTo(this, other);
        }

        @NotNull
        public final Node<V, L> component1() {
            return this.getN1();
        }

        @NotNull
        public final Node<V, L> component2() {
            return this.getN2();
        }

        @Nullable
        public final L component3() {
            return this.getLabel();
        }

        @NotNull
        public final UndirectedEdge<V, L> copy(@NotNull Node<V, L> n1, @NotNull Node<V, L> n2, @Nullable L label) {
            Intrinsics.checkNotNullParameter(n1, (String)"n1");
            Intrinsics.checkNotNullParameter(n2, (String)"n2");
            return new UndirectedEdge<V, L>(n1, n2, label);
        }

        public static /* synthetic */ UndirectedEdge copy$default(UndirectedEdge undirectedEdge, Node node, Node node2, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                node = undirectedEdge.getN1();
            }
            if ((n & 2) != 0) {
                node2 = undirectedEdge.getN2();
            }
            if ((n & 4) != 0) {
                object = undirectedEdge.getLabel();
            }
            return undirectedEdge.copy(node, node2, object);
        }

        public int hashCode() {
            Node<V, L> node = this.getN1();
            Node<V, L> node2 = this.getN2();
            L l = this.getLabel();
            return ((node != null ? ((Object)node).hashCode() : 0) * 31 + (node2 != null ? ((Object)node2).hashCode() : 0)) * 31 + (l != null ? l.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof UndirectedEdge)) break block3;
                    UndirectedEdge undirectedEdge = (UndirectedEdge)object;
                    if (!Intrinsics.areEqual(this.getN1(), undirectedEdge.getN1()) || !Intrinsics.areEqual(this.getN2(), undirectedEdge.getN2()) || !Intrinsics.areEqual(this.getLabel(), undirectedEdge.getLabel())) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0002\u0010\u0001*\u0004\b\u0003\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B7\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00018\u0003\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0005H\u00c6\u0003J\u0015\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0005H\u00c6\u0003J\u0010\u0010\u0011\u001a\u0004\u0018\u00018\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\nJR\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u00002\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u00052\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00018\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0013J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J*\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0018\u00010\u00052\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0005H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0018\u0010\u0007\u001a\u0004\u0018\u00018\u0003X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u001e"}, d2={"Lorg/molap/network/SimpleGraph$DirectedEdge;", "V", "L", "Lorg/molap/network/SimpleGraph$Edge;", "n1", "Lorg/molap/network/SimpleGraph$Node;", "n2", "label", "(Lorg/molap/network/SimpleGraph$Node;Lorg/molap/network/SimpleGraph$Node;Ljava/lang/Object;)V", "getLabel", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getN1", "()Lorg/molap/network/SimpleGraph$Node;", "getN2", "component1", "component2", "component3", "copy", "(Lorg/molap/network/SimpleGraph$Node;Lorg/molap/network/SimpleGraph$Node;Ljava/lang/Object;)Lorg/molap/network/SimpleGraph$DirectedEdge;", "equals", "", "other", "", "hashCode", "", "target", "node", "toString", "", "molap"})
    public static final class DirectedEdge<V, L>
    implements Edge<V, L> {
        @NotNull
        private final Node<V, L> n1;
        @NotNull
        private final Node<V, L> n2;
        @Nullable
        private final L label;

        @Override
        @Nullable
        public Node<V, L> target(@NotNull Node<V, L> node) {
            Intrinsics.checkNotNullParameter(node, (String)"node");
            return Intrinsics.areEqual(this.getN1(), node) ? this.getN2() : null;
        }

        @NotNull
        public String toString() {
            return this.getN1() + '>' + this.getN2() + (this.getLabel() == null ? "" : "" + '/' + this.getLabel());
        }

        @Override
        @NotNull
        public Node<V, L> getN1() {
            return this.n1;
        }

        @Override
        @NotNull
        public Node<V, L> getN2() {
            return this.n2;
        }

        @Override
        @Nullable
        public L getLabel() {
            return this.label;
        }

        public DirectedEdge(@NotNull Node<V, L> n1, @NotNull Node<V, L> n2, @Nullable L label) {
            Intrinsics.checkNotNullParameter(n1, (String)"n1");
            Intrinsics.checkNotNullParameter(n2, (String)"n2");
            this.n1 = n1;
            this.n2 = n2;
            this.label = label;
        }

        @Override
        public boolean equivalentTo(@NotNull Edge<V, L> other) {
            Intrinsics.checkNotNullParameter(other, (String)"other");
            return Edge.DefaultImpls.equivalentTo(this, other);
        }

        @NotNull
        public final Node<V, L> component1() {
            return this.getN1();
        }

        @NotNull
        public final Node<V, L> component2() {
            return this.getN2();
        }

        @Nullable
        public final L component3() {
            return this.getLabel();
        }

        @NotNull
        public final DirectedEdge<V, L> copy(@NotNull Node<V, L> n1, @NotNull Node<V, L> n2, @Nullable L label) {
            Intrinsics.checkNotNullParameter(n1, (String)"n1");
            Intrinsics.checkNotNullParameter(n2, (String)"n2");
            return new DirectedEdge<V, L>(n1, n2, label);
        }

        public static /* synthetic */ DirectedEdge copy$default(DirectedEdge directedEdge, Node node, Node node2, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                node = directedEdge.getN1();
            }
            if ((n & 2) != 0) {
                node2 = directedEdge.getN2();
            }
            if ((n & 4) != 0) {
                object = directedEdge.getLabel();
            }
            return directedEdge.copy(node, node2, object);
        }

        public int hashCode() {
            Node<V, L> node = this.getN1();
            Node<V, L> node2 = this.getN2();
            L l = this.getLabel();
            return ((node != null ? ((Object)node).hashCode() : 0) * 31 + (node2 != null ? ((Object)node2).hashCode() : 0)) * 31 + (l != null ? l.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DirectedEdge)) break block3;
                    DirectedEdge directedEdge = (DirectedEdge)object;
                    if (!Intrinsics.areEqual(this.getN1(), directedEdge.getN1()) || !Intrinsics.areEqual(this.getN2(), directedEdge.getN2()) || !Intrinsics.areEqual(this.getLabel(), directedEdge.getLabel())) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\f\u0012\u0004\u0012\u0002H\u0005\u0012\u0002\b\u00030\u0004\"\u0004\b\u0002\u0010\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\b0\u0007Jh\u0010\t\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\n0\u0004\"\u0004\b\u0002\u0010\u0005\"\u0004\b\u0003\u0010\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\n0\f22\u0010\r\u001a.\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\n0\u0004\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u0005\u0012\u0006\u0012\u0004\u0018\u0001H\n\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002Jh\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\n0\u0004\"\u0004\b\u0002\u0010\u0005\"\u0004\b\u0003\u0010\n2\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\n0\u000722\u0010\r\u001a.\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\n0\u0004\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u0005\u0012\u0006\u0012\u0004\u0018\u0001H\n\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J2\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\n0\u0004\"\u0004\b\u0002\u0010\u0005\"\u0004\b\u0003\u0010\n2\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\n0\u0007J2\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\n0\u0004\"\u0004\b\u0002\u0010\u0005\"\u0004\b\u0003\u0010\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\n0\f\u00a8\u0006\u0013"}, d2={"Lorg/molap/network/SimpleGraph$Companion;", "", "()V", "adjacent", "Lorg/molap/network/SimpleGraph;", "V", "adjacencyList", "Lorg/molap/network/AdjacencyList;", "", "createFromTerms", "L", "termForm", "Lorg/molap/network/TermForm;", "addFunction", "Lkotlin/Function4;", "", "fromAdjacencyList", "labeledAdjacent", "labeledTerms", "molap"})
    public static final class Companion {
        @NotNull
        public final <V, L> SimpleGraph<V, L> labeledTerms(@NotNull TermForm<? extends V, ? extends L> termForm) {
            Intrinsics.checkNotNullParameter(termForm, (String)"termForm");
            return this.createFromTerms(termForm, labeledTerms.1.INSTANCE);
        }

        @NotNull
        public final <V> SimpleGraph<V, ?> adjacent(@NotNull AdjacencyList adjacencyList) {
            Intrinsics.checkNotNullParameter((Object)adjacencyList, (String)"adjacencyList");
            return this.fromAdjacencyList(adjacencyList, adjacent.1.INSTANCE);
        }

        @NotNull
        public final <V, L> SimpleGraph<V, L> labeledAdjacent(@NotNull AdjacencyList<V, ? extends L> adjacencyList) {
            Intrinsics.checkNotNullParameter(adjacencyList, (String)"adjacencyList");
            return this.fromAdjacencyList(adjacencyList, labeledAdjacent.1.INSTANCE);
        }

        private final <V, L> SimpleGraph<V, L> createFromTerms(TermForm<? extends V, ? extends L> termForm, Function4<? super SimpleGraph<V, L>, ? super V, ? super V, ? super L, Unit> addFunction) {
            Object it;
            SimpleGraph graph = new SimpleGraph(null, null, 3, null);
            Iterable $this$forEach$iv = termForm.getNodes();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = element$iv;
                boolean bl = false;
                graph.addNode(it);
            }
            $this$forEach$iv = termForm.getEdges();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (TermForm.Term)element$iv;
                boolean bl = false;
                addFunction.invoke(graph, ((TermForm.Term)it).getN1(), ((TermForm.Term)it).getN2(), ((TermForm.Term)it).getLabel());
            }
            return graph;
        }

        /*
         * WARNING - void declaration
         */
        private final <V, L> SimpleGraph<V, L> fromAdjacencyList(AdjacencyList<V, ? extends L> adjacencyList, Function4<? super SimpleGraph<V, L>, ? super V, ? super V, ? super L, Unit> addFunction) {
            SimpleGraph graph = new SimpleGraph(null, null, 3, null);
            Iterable $this$forEach$iv = adjacencyList.getEntries();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AdjacencyList.Entry it = (AdjacencyList.Entry)element$iv;
                boolean bl = false;
                graph.addNode(it.getNode());
            }
            $this$forEach$iv = adjacencyList.getEntries();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AdjacencyList.Entry $dstr$node$links = (AdjacencyList.Entry)element$iv;
                boolean bl = false;
                Object v = $dstr$node$links.component1();
                List links2 = $dstr$node$links.component2();
                Iterable $this$forEach$iv2 = links2;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    void node;
                    AdjacencyList.Link it = (AdjacencyList.Link)element$iv2;
                    boolean bl2 = false;
                    addFunction.invoke(graph, (Object)node, it.getNode(), it.getLabel());
                }
            }
            return graph;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

