/*
 * Copyright (c) 2014 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.aggregates.cuboid

import org.molap.aggregates.cube.Cube
import org.molap.aggregates.cube.Dimensions
import org.molap.aggregates.cube.DistributiveStatistics
import org.molap.aggregates.cube.Group
import org.molap.series.Series

/**
 *
 */
interface Cuboid {
    val cube: Cube?
    val dimensions: Dimensions?
    val groups: Iterable<Any?>?
    fun getGroupsStartingWith(group: Group?): Iterable<Group?>?
    fun getGroupsStartingWithCount(group: Group?): Int
    val groupsCount: Int
    val values: Set<Any?>?
    var isDirty: Boolean
    fun getDistributiveStatistics(
        group: Group?,
        column: Series<Any,Any>,
        rowExcluder: DistributiveStatistics.RowFilter<Any>
    ): DistributiveStatistics?

//    fun getUnivariateStatistics(group: Group?, column: Series?): UnivariateStatistics?
//    fun <T> getAggregate(group: Group?, func: AggregateSeriesFunction<T>?): T
//    fun getDistinct(group: Group?, columm: Series?): Set<Any?>?
    fun getRows(group: Group?): Iterable<Any?>?

    /**
     * Add one level to the group by.
     *
     * @param columns the levels to add
     * @return
     */
    fun drillDown(vararg columns: Any?): Cuboid?

    /**
     * Remove the last level from the group by.
     *
     * @return
     */
    fun drillUp(): Cuboid?

    /**
     * Filter on a single single values.
     *
     * @param value
     * @return
     */
    fun slice(value: Any?): Cuboid?

    /**
     * Filter on multiple values.
     *
     * @param valuesSets
     * @return
     */
    fun dice(valuesSets: Set<Any?>?): Cuboid?
    fun collapse(): Cuboid?

    companion object {
        val ALL: Any = object : Any() {
            override fun toString(): String {
                return "(all)"
            }
        }
    }
}