package org.molap.dataframe

import org.molap.index.DefaultUniqueIndex
import org.molap.index.UniqueIndex

internal class ColumnDefaultReIndexRecipe<R,C,V>(private val dataframe: DataFrame<R,C,V>, private val column: C, private val keepColumn: Boolean = true) : ReIndexRecipe<V, C> {
    override fun buildRowIndex(): UniqueIndex<V> {
        val keys = ArrayList<V>(dataframe.rowCount)
        for (row in dataframe.rows()) {
            keys.add(dataframe.getValueAt(row, column))
        }
        return DefaultUniqueIndex(keys)
    }

    override fun buildColumnIndex(): UniqueIndex<C> {
//        return if (keepColumn) {
            return dataframe.columnIndex
//        } else {
//            dataframe.columnIndex.difference(DefaultUniqueIndex<C?>(column))
//        }
    }
}