/*
 * Copyright (c) 2015 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.dataframe

import com.macrofocus.common.collection.UniversalComparator

/**
 * Created by luc on 27/08/15.
 */
class SingleSortKey<Column> : SortKey<Column> {
    override val column: Column
    override val sortOrder: SortOrder
    override var comparator: Comparator<Any?>

    constructor(column: Column, sortOrder: SortOrder) {
        this.column = column
        this.sortOrder = sortOrder
        comparator = UniversalComparator()
    }

    constructor(column: Column, sortOrder: SortOrder, comparator: Comparator<Any?>) {
        this.column = column
        this.sortOrder = sortOrder
        this.comparator = comparator
    }

    override fun <Row> compare(
        dataFrame: AbstractDataFrame<Row, Column, Any>,
        o1: Row,
        o2: Row
    ): Int {
        return if (sortOrder != SortOrder.UNSORTED) {
            val v1 = dataFrame.getValueAt(o1, column)
            val v2 = dataFrame.getValueAt(o2, column)
            val compare: Int = comparator.compare(v1, v2)
            if (sortOrder == SortOrder.ASCENDING) {
                compare
            } else {
                -compare
            }
        } else {
            -2
        }
    }

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SingleSortKey<*>

        if (column != other.column) return false
        if (sortOrder != other.sortOrder) return false
        if (comparator != other.comparator) return false

        return true
    }

    override fun hashCode(): Int {
        var result = column?.hashCode() ?: 0
        result = 31 * result + sortOrder.hashCode()
        result = 31 * result + comparator.hashCode()
        return result
    }
}