/*
 * Copyright (c) 2015 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.dataframe

/**
 * SortOrder is an enumeration of the possible sort orderings.
 */
enum class SortOrder {
    /**
     * Enumeration value indicating the items are sorted in increasing order.
     * For example, the set `1, 4, 0` sorted in
     * `ASCENDING` order is `0, 1, 4`.
     */
    ASCENDING,

    /**
     * Enumeration value indicating the items are sorted in decreasing order.
     * For example, the set `1, 4, 0` sorted in
     * `DESCENDING` order is `4, 1, 0`.
     */
    DESCENDING,

    /**
     * Enumeration value indicating the items are unordered.
     * For example, the set `1, 4, 0` in
     * `UNSORTED` order is `1, 4, 0`.
     */
    UNSORTED
}