/*
 * Copyright (c) 2014 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.aggregates.aggregation


import org.molap.aggregates.cube.Group
import org.molap.aggregates.cuboid.Cuboid
import org.molap.series.Series
import kotlin.reflect.KClass

class CountDistinctWithNullAggregation(private val column: Series<Any?, Any?>) : AbstractAggregation<Any?>() {
    override val type: KClass<Any>
        get() = Int::class as KClass<Any>

    override fun compute(cuboid: Cuboid?, group: Group?): Any? {
        val distinct: Set<Any?>? = cuboid!!.getDistinct(group, column)
        return if (distinct != null) {
            distinct.size
        } else {
            null
        }
    }

    override fun toString(): String {
        return "CountDistinctWithNull(" + column.name + ")"
    }
}