/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.aggregates.aggregation

import org.molap.aggregates.cube.Group
import org.molap.aggregates.cube.UnivariateStatistics
import org.molap.aggregates.cuboid.Cuboid
import org.molap.series.Series
import kotlin.reflect.KClass

class UnivariateStatisticsAggregation(column: Series<Any?,Any?>?) : AbstractAggregation<UnivariateStatistics>() {
    private val column: Series<Any?,Any?>?
    override val type: KClass<Any>
        get() = UnivariateStatistics::class as KClass<Any>

    override fun compute(cuboid: Cuboid?, group: Group?): UnivariateStatistics? {
        return cuboid!!.getUnivariateStatistics(group, column)
    }

    override fun toString(): String {
        return "UnivariateStatistics(" + column!!.name.toString() + ")"
    }

    init {
        this.column = column
    }
}