/*
 * Copyright (c) 2014 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.aggregates.cube

import com.macrofocus.common.collection.arraycopy

class Dimensions(vararg path: Any?) {
    val path: Array<out Any?> = path
    val columnIndex: MutableMap<Any?, Int?>? = HashMap()
//    private val orderedColumns: MutableList<OrderedColumn?>? = ArrayList()

//    fun createOrderedGroup(group: Group?): Group? {
//        val path = arrayOfNulls<Any?>(orderedColumns!!.size)
//        for (i in orderedColumns.indices) {
//            val orderedColumn = orderedColumns[i]
//            path[i] = group.getPath(orderedColumn!!.index)
//        }
//        return GroupFactory.create(path)
//    }
//
    fun drillDown(vararg columns: Any?): Dimensions? {
        val path = arrayOfNulls<Any?>(path.size + columns.size)
        arraycopy(this.path, 0, path, 0, this.path.size)
        arraycopy(columns, 0, path, this.path.size, columns.size)
        return create(*path)
    }
//
    fun drillUp(): Dimensions? {
//        assert(path!!.size > 0) { this }
        return if (path.size > 0) {
            val path = arrayOfNulls<Any?>(path.size - 1)
            arraycopy(this.path, 0, path, 0, path.size)
            create(*path)
        } else {
            null
        }
    }

    val last: Any?
        get() = path[path.size - 1]

    override fun equals(o: Any?): Boolean {
        if (this === o) return true
        if (o !is Dimensions) return false
        val path1 =
            o as Dimensions?
        // Probably incorrect - comparing Object[] arrays with Arrays.equals
        return path.contentEquals(path1!!.path)
    }

    override fun hashCode(): Int {
        return path.contentHashCode()
    }

//    override fun toString(): String {
//        return "Dimensions{" +
//                "path=" + java.util.Arrays.toString(path) +
//                '}'
//    }
//
    fun getIndex(column: Any?): Int? {
        return columnIndex!![column]
    }
//
//    private class OrderedColumn(val column: Any?, val index: Int) :
//        Comparable<OrderedColumn?> {
//
//        override fun equals(o: Any?): Boolean {
//            if (this === o) return true
//            if (o == null || javaClass != o.javaClass) return false
//            val that =
//                o as OrderedColumn?
//            return column == that!!.column
//        }
//
//        override fun hashCode(): Int {
//            return column.hashCode()
//        }
//
//        override fun compareTo(o: OrderedColumn?): Int {
//            val x = getId(column)
//            val y = getId(o!!.column)
//            return if (x < y) -1 else if (x == y) 0 else 1
//        }
//
//        companion object {
//            private val ids: MutableMap<Any?, Long?>? = WeakHashMap<Any?, Long?>()
//            private val nextId: AtomicLong? = AtomicLong(0)
//            private fun getId(column: Any?): Long {
//                if (!ids!!.containsKey(column)) {
//                    ids[column] = nextId.getAndIncrement()
//                }
//                return ids[column]!!
//            }
//        }
//
//    }
//
    companion object {
        private operator fun get(vararg path: Any?): Dimensions {
            return Dimensions(*path)
        }

        fun create(vararg path: Any?): Dimensions {
            return get(*path)
        }
    }
//
    init {
//        this.path = path
//        columnIndex = HashMap()
        for (i in 0 until path.size) {
            val column = path[i]
            columnIndex!![column] = i
        }
//        orderedColumns = java.util.ArrayList<OrderedColumn?>()
//        for (i in 0 until path.size) {
//            val column = path[i]
//            orderedColumns.add(OrderedColumn(column, i))
//        }
//        java.util.Collections.sort(orderedColumns)
    }
}