/*
 * Copyright (c) 2017 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.aggregates.cube

/**
 * A strategy to pick a pivoting index of an array for doing partitioning.
 * @see MedianOf3PivotingStrategy
 */
interface PivotingStrategyInterface {
    /**
     * Find pivot index of the array so that partition and K<sup>th</sup>
     * element selection can be made
     * @param work data array
     * @param begin index of the first element of the slice
     * @param end index after the last element of the slice
     * @return the index of the pivot element chosen between the
     * first and the last element of the array slice
     */
    fun pivotIndex(work: DoubleArray, begin: Int, end: Int): Int
}