/*
 * Copyright (c) 2014 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.aggregates.cuboid

import org.molap.aggregates.cube.*
import org.molap.dataframe.DataFrameEvent
import org.molap.dataframe.DataFrameListener

/**
 * The top-most cuboid, which holds the highest-level of summarization.
 */
class ApexCuboid(cube: InMemoryCube, dimensions: Dimensions) : AbstractCuboid(cube) {
    override val cube: Cube = cube
    override val dimensions: Dimensions
    val group: Group = GroupFactory.createRoot()
    override val groups: List<Group> = listOf<Group>(group)
    private val listener: DataFrameListener<Any?,Any?> = object : DataFrameListener<Any?,Any?> {
        override fun dataFrameChanged(event: DataFrameEvent<Any?,Any?>) {
            isDirty = true
        }
    }

    override fun drillDown(vararg columns: Any?): Cuboid {
        val dimensions: Dimensions? = cube.root!!.drillDown(*columns)
        val diceValues: Array<Set<Any>?> = arrayOfNulls(columns.size)
        val structureValues = BooleanArray(columns.size) { false }
        return cube.getCuboid(dimensions!!, cube.dice!!.drillDownByArray(diceValues as Array<Set<Any?>>), cube.structure!!.drillDown(*structureValues))!!
    }

    override fun drillUp(): Cuboid? {
//        assert(false)
        return null
    }

    override fun slice(values: Any?): Cuboid? {
        return null
    }

    override fun dice(valuesSets: Set<Any?>): Cuboid? {
        return null
    }

    override fun collapse(): Cuboid? {
        return null
    }

    override fun getGroupsStartingWith(group: Group?): Iterable<Group>? {
        return null
    }

    override fun getGroupsStartingWithCount(group: Group?): Int {
        return 0
    }

    override val groupsCount: Int
        get() { return groups.size }

    override val values: Set<Any?>? = emptySet()

    override fun getRows(group: Group?): Iterable<Any?> {
//        assert(group === this.group)
        return cube.dataFrame.rows()
    }

    init {
        this.dimensions = dimensions
        cube.dataFrame.addWeakDataFrameListener(listener)
    }
}