/*
 * Copyright (c) 2014 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.aggregates.query

import org.molap.aggregates.aggregation.Aggregation
import org.molap.aggregates.cube.Dimensions
import org.molap.aggregates.cube.Group
import org.molap.aggregates.cuboid.Cuboid
import org.molap.dataframe.DataFrame

interface Query {
    fun getValue(path: Group?, aggregation: Aggregation<Any?>): Any?
    val dimensions: Dimensions?
    val aggregations: Array<Aggregation<Any?>>
    val groups: List<Any>?
    fun drillDown(vararg columns: Any?): Query
    fun drillUp(): Query
    fun slice(value: Any?): Query
    fun dice(valuesSets: Set<Any?>?): Query
    fun pivot(aggregation: Aggregation<Any?>?, values: Array<Any?>?): Query?
    fun pivot(aggregation: Aggregation<Any?>?): Query
    fun collapse(): Query
    fun order(vararg aggregations: Aggregation<Any?>?): Query
    fun on(vararg cuboids: Cuboid): Query
    val cuboid: Cuboid?
    fun setDice(valuesSets: Set<Any?>)
    fun asDataFrame(includeIndex: Boolean): DataFrame<*,*,*>?

    /**
     * Add a listener to the list that's notified each time a change to the query occurs.
     *
     * @param listener the QueryListener
     */
    fun addQueryListener(listener: QueryListener)

    /**
     * Add a listener to the list that's notified each time a change to the query occurs. The listener will
     * automatically be disposed of should no other object have a reference to it.
     *
     * @param listener the QueryListener
     */
    fun addWeakQueryListener(listener: QueryListener)

    /**
     * Remove a listener to the list that's notified each time a change to the query occurs.
     *
     * @param listener the QueryListener
     */
    fun removeQueryListener(listener: QueryListener)

    /**
     * Remove all listeners to the list that's notified each time a change to the query occurs.
     */
    fun removeQueryListeners()
}