package org.molap.dataframe

import org.molap.index.UniqueIndex

class FilterDataFrame<R,C,V>(originalDataFrame: DataFrame<R,C,V>, rowFilter: (R) -> Boolean = { true }) : ReMappedDataFrame<R,C,V>(originalDataFrame, object : ReMappedRecipe<R,C> {
    override fun buildRowIndex(): UniqueIndex<R> {
        val toKeep = ArrayList<Int>()
        for(row in originalDataFrame.rows()) {
           if(rowFilter.invoke(row)) {
               toKeep.add(originalDataFrame.getRowAddress(row))
           }
        }
        return originalDataFrame.rowIndex.keepAddresses(toKeep.toIntArray())
    }

    override fun buildColumnIndex(): UniqueIndex<C> {
        return originalDataFrame.columnIndex
    }
}) {
}