/*
 * Copyright (c) 2014 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.dataframe

import org.molap.index.UniqueIndex
import org.molap.series.AbstractSeries
import org.molap.series.Series
import kotlin.reflect.KClass

/**
 * An indexed data frame.
 *
 * @param <R> the type of row keys
 * @param <V> the type of column keys
</V></R> */
class IndexedDataFrame<R, C, V> : AbstractDataFrame<R, C, V> {
    override val columnIndex: UniqueIndex<C>
    override val rowIndex: UniqueIndex<R>
    private val series: Array<Series<R, V>>

//    constructor(vararg series: Series<R, V>) {
//        this.series = series
//        val rows: Set<R> = HashSet()
//        for (s in series) {
//            for (r in s.keys()!!) {
//                rows.add(r)
//            }
//        }
//        val columns = arrayOfNulls<Any>(series.size)
//        for (i in 0 until series.size) {
//            val s = series[i]
//            if (s.name != null) {
//                columns[i] = s.name
//            } else {
//                columns[i] = i
//            }
//        }
//        val array = rows.toArray() as Array<R>
//        rowIndex = DefaultUniqueIndex.< R > fromArray < R ? > array
//        columnIndex = DefaultUniqueIndex.< Object > fromArray < Any ? > columns
//    }

    constructor(
        rowIndex: UniqueIndex<R>,
        columnIndex: UniqueIndex<C>,
        series: Array<Series<R, V>>
    ) {
        this.rowIndex = rowIndex
        this.columnIndex = columnIndex
        this.series = series
    }

    override fun getRowClass(row: R): KClass<Any>? {
        return null
    }

    override fun getColumnClass(column: C): KClass<out Any> {
        val address = columnIndex.getAddress(column)
//        return if (address >= 0) {
           return series[address].type
//        } else {
//            throw IllegalArgumentException("Column not found $column")
//        }
    }

    fun getRow(row: Any?): Series<Any, *>? {
        return null
    }

    override fun getColumn(column: C): Series<R, V> {
        return ColumnSeries(column, rowIndex)
    }

    override fun getValueAt(row: R, column: C): V {
        val address = columnIndex.getAddress(column)
//        return if (address >= 0) {
            return series[address][row]
//        } else {
//            null
//        }
    }

    override fun rows(): Iterable<R> {
        return rowIndex.keys()
    }

    override fun columns(): Iterable<C> {
        return columnIndex.keys()
    }

    override fun getRowKey(index: Int): R {
        return rowIndex.getKey(index)
    }

    override fun getColumnKey(index: Int): C {
        return columnIndex.getKey(index)
    }

    override fun getRowAddress(row: R): Int {
        return rowIndex.getAddress(row)
    }

    override fun getColumnAddress(column: C): Int {
        return columnIndex.getAddress(column)
    }

    override val rowCount: Int
        get() = rowIndex.size

    override val columnCount: Int
        get() = columnIndex.size

//     fun reindexRowsUsingColumns(vararg rows: R): DataFrame<MultiKey, Any?, V> {
//        var r = 0
//        val keys = ArrayList<MultiKey>(rowCount)
//        for (row in rows()) {
//            val values = arrayOfNulls<Any>(rows.size)
//            var c = 0
//            for (column in rows) {
//                values[c++] = getValueAt(row, column)
//            }
//            val key = MultiKey(*values)
//            keys[r++] = key
//        }
//        val index: DefaultUniqueIndex<MultiKey> = DefaultUniqueIndex<MultiKey>(keys)
//        val series: Array<Series<*, *>?> =
//            arrayOfNulls<Series<*, *>>(columnCount)
//        var c = 0
//        for (column in columns()!!) {
//            series[c++] = ColumnSeries2<MultiKey>(column, index)
//        }
//        return IndexedDataFrame(index, columnIndex, series)
//    }

    fun join(
        series: Series<*, *>?,
        columns: Array<Any?>?
    ): DataFrame<*, *, *>? {
        return null
    }

    inner class ColumnSeries(column: C, index: UniqueIndex<R>) : AbstractSeries<R, V>() {
        override val name: C
        private val index: UniqueIndex<R>

        override val type: KClass<out Any>
            get() = getColumnClass(name)

        override operator fun get(key: R): V {
            val address = index.getAddress(key)
//            return if (address >= 0) {
                return getValueAt(rowIndex.getKey(address), name)
//            } else {
//                System.err.println("Could not find " + key);
//                null
//            }
        }

        override fun getKey(i: Int): R {
            return getRowKey(i)
        }

        override fun size(): Int {
            return index.size
        }

        override fun getAddress(key: R): Int {
            return getRowAddress(key)
        }

        override fun keys(): Iterable<R>? {
            return index.keys()
        }

//        override fun <L> reindex(vararg keys: L): Series<L, V>? {
//            return null
//        }
//
//        override fun head(count: Int): Series<R, V>? {
//            return null
//        }
//
//        override fun tail(count: Int): Series<R, V>? {
//            return null
//        }

        init {
//            assert(column != null)
            name = column
            this.index = index
        }
    }

//    inner class ColumnSeries2<K>(column: Any?, index: UniqueIndex<*>) : AbstractSeries<K, V>() {
//        val name: Any?
//        private val index: UniqueIndex<K>
//
//        override val type: KClass<Any>
//            get() = getColumnClass(name)
//
//        override operator fun get(key: K): V {
//            val address = index.getAddress(key)
////            return
////            if (address >= 0) {
//                return getValueAt(rowIndex.getKey(address), name)
////            } else {
////                System.err.println("Could not find " + key);
////                null
////            }
//        }
//
//        override fun getKey(i: Int): K {
//            throw UnsupportedOperationException("Not yet implemented")
//        }
//
//        override fun size(): Int {
//            return index.size
//        }
//
//        override fun getAddress(key: K): Int {
//            throw UnsupportedOperationException("Not yet implemented")
//        }
//
//        override fun keys(): Iterable<K>? {
//            return index.keys()
//        }
//
//        override fun <L> reindex(vararg keys: L): Series<L, V>? {
//            return null
//        }
//
//        override fun head(count: Int): Series<K, V>? {
//            return null
//        }
//
//        override fun tail(count: Int): Series<K, V>? {
//            return null
//        }
//
//        init {
////            assert(column != null)
//            name = column
//            this.index = index
//        }
//    }
}