package org.molap.dataframe.rowmajor

import kotlin.reflect.KClass

open class AccessorRowMajorDataFrame<R, C : RowMajorDataFrame.Column<R, V>, V>(columns: Array<C>) :
    AbstractRowMajorDataFrame<R, C, V>(*columns) {
    override fun getColumnClass(c: C): KClass<*> {
        return c.type
    }

    override fun getValueAt(r: R, c: C): V {
        return c.getValue(r)
    }

    override fun setValueAt(row: R, column: C, value: V) {
        // ToDo
        //        column.setValue(row, value);
    }
}