package org.molap.exporter

import com.macrofocus.common.units.Quantity
import org.molap.dataframe.DataFrame
import kotlin.reflect.KClass

class DelimitedDataFrameWriter(
    private val output: DataFrameOutput,
    private val delimiter: String,
    private val newLine: String
) :
    DataFrameWriter {
    private var row = 0
    private var column = 0

    override fun start() {
    }

//    fun setTimeZone(timeZone: TimeZone?) {
//    }

    override fun writeColumnName(value: String?, hasMore: Boolean) {
        var value = value
        if (value != null) {
            if (value.contains(delimiter) || value.contains("\"") || value.contains("\n")) {
                value = "\"" + value.replace("\"".toRegex(), "\"\"") + "\""
            }
            output.write(value)
        }
        nextColumn(hasMore)
    }

    override fun includeType(): Boolean {
        return false
    }

    override fun writeType(cl: KClass<*>, hasMore: Boolean) {
    }

    override fun <R, C, V> writeCell(value: Any?, dataFrame: DataFrame<R, C, V>, rowKey: R, columnKey: C) {
        if (value != null) {
            var str: String
//            if (value is Array<String>) {
//                val array = value
//                str = ""
//                for (i in array.indices) {
//                    val s = array[i]
//                    str += s
//                    if (i < array.size - 1) {
//                        str += "."
//                    }
//                }
//            } else {
                str = if (value is Number) {
                    numberToString(value as Number?)
                } else if(value is Quantity<*>) {
                    numberToString(value.amount as Number?)
                } else {
                    value.toString()
                }
                if (str.contains(delimiter) || str.contains("\"") || str.contains("\n")) {
                    str = "\"" + str.replace("\"".toRegex(), "\"\"") + "\""
                }
//            }
            output.write(str)
        }
    }

    override fun nextColumn(hasMore: Boolean) {
        column++
        if (hasMore) {
            output.write(delimiter)
        }
    }

    override fun nextRow() {
        column = 0
        row++
        output.write(newLine)
    }

    override fun close() {
        output.close()
    }

    companion object {
        //    private static DecimalFormat decimalFormat = new DecimalFormat("#################0.#################", new DecimalFormatSymbols(Locale.ENGLISH));
        fun numberToString(value: Number?): String {
            if (value == null) {
                return ""
            }
            return if (value is Double) {
                val v = value.toDouble()
                if (v.isNaN()) {
                    return ""
                } else if (v.isInfinite()) {
                    return v.toString()
                }
                v.toString()
//                BigDecimal(v, MathContext(15, java.math.RoundingMode.HALF_EVEN)).stripTrailingZeros().toPlainString()
            } else if (value is Float) {
                val v = value.toFloat()
                if (v.isNaN()) {
                    return ""
                } else if (v.isInfinite()) {
                    return v.toString()
                }
//                BigDecimal(v, MathContext(6, java.math.RoundingMode.HALF_EVEN)).stripTrailingZeros().toPlainString()
                v.toString()
            } else if (value is Long) {
                val v = value.toLong()
                v.toString()
            } else if (value is Int) {
                val v = value.toInt()
                v.toString()
            } else if (value is Byte) {
                val v = value.toByte()
                v.toString()
            } else if (value is Short) {
                val v = value.toShort()
                v.toString()
//            } else if (value is BigDecimal) {
//                (value as BigDecimal).toPlainString()
            } else {
                value.toString()
            }
        }
    }
}
