/*
 * Copyright (c) 2014 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.index

import com.macrofocus.common.index.AbstractIndex

abstract class AbstractUniqueIndex<K> : AbstractIndex<K>(), UniqueIndex<K> {
//    override fun union(other: UniqueIndex<K>): UniqueIndex<K> {
//        val keys: MutableSet<K> = LinkedHashSet()
//        for (k in keys()!!) {
//            keys.add(k)
//        }
//        for (k in other!!.keys()!!) {
//            keys.add(k)
//        }
//        return DefaultUniqueIndex<K>(*keys.toTypedArray())
//    }
//
//    override fun intersection(other: UniqueIndex<K>): UniqueIndex<K> {
//        val clone: MutableSet<K> = LinkedHashSet()
//        for (k in keys()!!) {
//            clone.add(k)
//        }
//        val it = clone.iterator()
//        while (it.hasNext()) {
//            if (!other!!.contains(it.next())) {
//                it.remove()
//            }
//        }
//        return DefaultUniqueIndex<K>(*clone.toTypedArray())
//    }
//
//    override fun difference(other: UniqueIndex<K>): UniqueIndex<K> {
//        val clone: MutableSet<K> = LinkedHashSet()
//        for (k in keys()!!) {
//            if (!other!!.contains(k)) {
//                clone.add(k)
//            }
//        }
//        return DefaultUniqueIndex<K>(*clone.toTypedArray())
//    }

    override fun keys(): Iterable<K> {
        return object : Iterable<K> {
            override fun iterator(): Iterator<K> {
                return object : MutableIterator<K> {
                    var i = 0
                    override fun hasNext(): Boolean {
                        return i < size
                    }

                    override fun next(): K {
                        return getKey(i++)
                    }

                    override fun remove() {
                        throw UnsupportedOperationException()
                    }
                }
            }
        }
    }
}