package org.molap.index

import com.macrofocus.common.collection.*
import com.macrofocus.common.collection.Iterables.forIntArray
import kotlin.jvm.Synchronized
import kotlin.math.min

class IntegerListUniqueIndex(private val list: IntArray) : AbstractUniqueIndex<Int>() {
    private val lazy: Lazy
    override fun contains(key: Int): Boolean {
        return lazy.getIndex().containsKey(key)
    }

    override fun getAddress(key: Int): Int {
        return lazy.getIndex().getValue(key)
    }

    override fun keys(): Iterable<Int> {
        return forIntArray(*list)
    }

    override fun getKey(i: Int): Int {
//        return if (i >= 0 && i < size) {
            return list[i]
//        } else {
//            null
//        }
    }

    override val size: Int
        get() = list.size

    override fun head(count: Int): UniqueIndex<Int> {
        return IntegerListUniqueIndex(copyOf(list, min(list.size, count)))
    }

    override fun tail(count: Int): UniqueIndex<Int> {
        return IntegerListUniqueIndex(copyOfRange(list, list.size - count, list.size))
    }

    override fun keepAddresses(addresses: IntArray): UniqueIndex<Int> {
        val keys = IntArray(addresses.size)
        for (i in addresses.indices) {
            keys[i] = list[addresses[i]]
        }
        return IntegerListUniqueIndex(addresses)
    }

    private inner class Lazy {
        private var index: TIntIntMap? = null
        @Synchronized
        fun getIndex(): TIntIntMap {
            if (index == null) {
                index = TIntIntHashMap(list.size)
                for (i in list.indices) {
                    val key = list[i]
                    index!!.put(key, i)
                }
            }
            return index!!
        }
    }

    /**
     * Creates a new index with a set of keys.
     * Note: the keys need to be unique
     *
     * @param keys the keys
     */
    init {
        lazy = Lazy()
    }
}
