package org.molap.series

import org.molap.index.IntegerRangeUniqueIndex
import org.molap.index.UniqueIndex
import kotlin.reflect.KClass

class DoubleSeries : AbstractSeries<Int, Double?>, MutableSeries<Int, Double?> {
    override val name: Any?
    private val available: BooleanArray?
    private val values: DoubleArray
    private val index: UniqueIndex<Int>

    constructor(values: DoubleArray) {
        name = null
        this.values = values
        index = IntegerRangeUniqueIndex(0, values.size - 1)
        available = null
    }

    constructor(name: Any?, values: DoubleArray) {
        this.name = name
        this.values = values
        index = IntegerRangeUniqueIndex(0, values.size - 1)
        available = null
    }

    constructor(values: DoubleArray, available: BooleanArray?) {
        name = null
        this.values = values
        index = IntegerRangeUniqueIndex(0, values.size - 1)
        this.available = available
    }

    private constructor(values: DoubleArray, index: UniqueIndex<Int>) {
        name = null
        this.values = values
        this.index = index
        available = null
    }

    override val type: KClass<Any>
        get() = Double::class as KClass<Any>

    override operator fun get(key: Int): Double? {
        return if (isNull(key)) null as Double? else values[key]
    }

    fun isNull(key: Int): Boolean {
        return available != null && !available[key]
    }

    fun getDouble(key: Int): Double {
        return values[key].toDouble()
    }

    override fun getKey(i: Int): Int {
        return index.getKey(i)
    }

    override fun size(): Int {
        return index.size
    }

    override fun getAddress(key: Int): Int {
        return index.getAddress(key)
    }

    override operator fun set(key: Int, value: Double?) {
        if(value != null) {
            values[key] = value
            if(available != null) {
                available[key] = true
            } else {
                // ToDo: Exception?
            }
        } else {
            if(available != null) {
                available[key] = false
            } else {
                // ToDo: Exception?
            }
        }
    }

    override fun keys(): Iterable<Int> {
        return index.keys()
    }

    fun <L> reindex(vararg keys: L): Series<L, Double>? {
        return null
    }

    fun head(count: Int): Series<Int, Double>? {
        return reindex(index.head(count))
    }

    fun tail(count: Int): Series<Int, Double>? {
        return reindex(index.tail(count))
    }

    fun <K> reindex(index: UniqueIndex<K>?): Series<K, Double>? {
//        return new IndexedSeries<K,Double>(getName(), values, index);
        return null
    }
}
