/*
 * Copyright (c) 2018 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.subset

import kotlin.math.ceil

/**
 * Created by luc on 01/07/16.
 */
class AutoSigmaDistributionStrategy<Value>(
    numberOfBins: Int,
    override val minValue: Double,
    private val mean: Double,
    private val stdDev: Double,
    override val maxValue: Double
) : DistributionDimension.DistributionStrategy<Value, Int> {
    private val numberOfBinsAbove: Int
    private val numberOfBinsBelow: Int
    private val numberOfBins: Int
    private val lsl: Double
    private val usl: Double
    override fun getBinStartValue(bin: Int): Double {
        return bin * ((maxValue - minValue) / numberOfBins) + minValue
    }

    override fun getBinEndValue(bin: Int): Double {
        return (bin + 1) * ((maxValue - minValue) / numberOfBins) + minValue
    }

    override fun isBinnable(value: Value): Boolean {
//        return value != null && (value is Number || value is java.util.Date)
        return value != null && (value is Number)
    }

    override fun valueToBin(value: Value): Int {
//        return if (value != null) {
//            if (value is java.util.Date) {
//                val v: Double = (value as java.util.Date).getTime().toDouble()
//                getSigmaLevel(v)
//            } else
                if (value is Number) {
                val v = (value as Number).toDouble()
                return getSigmaLevel(v)
            } else {
                return -3
            }
//        } else {
//            null
//        }
    }

    fun getSigmaLevel(v: Double): Int {
        if (v < minValue) return -1
        if (v > maxValue) return -2
        val sigma = (v - mean) / stdDev
        return if (sigma >= 0) {
            sigma.toInt() + numberOfBinsBelow
        } else {
            sigma.toInt() + (numberOfBinsBelow - 1)
        }

//        if (v == maxValue) return (numberOfBins - 1);
//        if (v == minValue) return 0;
//        return (int) ((v - minValue) / ((maxValue - minValue) / numberOfBins));
    }

    init {
        lsl = minValue
        usl = maxValue
        numberOfBinsAbove = ceil((maxValue - mean) / stdDev).toInt()
        numberOfBinsBelow = ceil((mean - minValue) / stdDev).toInt()
        this.numberOfBins = numberOfBinsAbove + numberOfBinsBelow
    }
}