/*
 * Copyright (c) 2015 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.subset

import com.macrofocus.common.selection.MutableSelection

/**
 * Created by luc on 16/05/15.
 */
class DefaultCategoricalDimension<Row, Column, Value>(
    dataFrame: SubsetDataFrame<Row, Column, Value>,
    column: Column,
    filteringCallback: FilteringCallback<Row>,
    selection: MutableSelection<Row>?
) : DefaultBinningDimension<Row, Column, Value, Value>(dataFrame, column, filteringCallback, selection, null) {
    private inner class CategoricalBinningStrategy<Row, Column, Value>(dataFrame: SubsetDataFrame<Row, Column, Value>, column: Column) :
        SingleBinningDimension.SingleBinningStrategy<Row, Value> {
        private val dataFrame: SubsetDataFrame<Row, Column, Value>
        private val column: Column
        val minValue: Double
            get() = 0.0
        val maxValue: Double
            get() = bins!!.size().toDouble()

        override fun isBinnable(row: Row): Boolean {
            // True if null values are accepted
            return true
        }

        override fun rowToBin(row: Row): Value {
            return dataFrame.unfilteredDataFrame.getValueAt(row, column)
        }

        init {
            this.dataFrame = dataFrame
            this.column = column
        }
    }

    init {
        binningStrategy = CategoricalBinningStrategy<Row, Column, Value>(dataFrame, column)
    }
}