/*
 * Copyright (c) 2015 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.subset

import com.macrofocus.common.timer.CPTimer

/**
 * Created by luc on 16/05/15.
 */
interface Dimension<Row> {
    val name: String?
    var updateTimer: CPTimer?
    val activeIndices: IntArray?
    val isReducable: Boolean
    fun reduce(otherActiveIndices: IntArray?)
    fun markDirty()
    fun materializeIndex()
    fun filterAll()
    fun addDimensionListener(listener: DimensionListener<Row>)
    fun addWeakDimensionListener(listener: DimensionListener<Row>)
    fun removeDimensionListener(listener: DimensionListener<Row>)
    fun removeDimensionListeners()
}