/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.subset

/**
 * Created by luc on 01/07/16.
 */
interface DistributionDimension<Row, Value, Bin> : SingleBinningDimension<Row, Bin> {
    var distributionStrategy: DistributionStrategy<Value, Bin>?
    fun getBinStartValue(value: Bin): Double
    fun getBinEndValue(value: Bin): Double
    val minValue: Double
    val maxValue: Double

    interface DistributionStrategy<Value, Bin> {
        fun getBinStartValue(value: Bin): Double
        fun getBinEndValue(value: Bin): Double
        val minValue: Double
        val maxValue: Double
        fun isBinnable(value: Value): Boolean
        fun valueToBin(value: Value): Bin
    }
}