/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.subset

/**
 * Created by luc on 01/07/16.
 */
class FixedDistributionStrategy<Value>(private val numberOfBins: Int, override val minValue: Double, override val maxValue: Double) :
    DistributionDimension.DistributionStrategy<Value, Int> {
    override fun getBinStartValue(bin: Int): Double {
        return bin * ((maxValue - minValue) / numberOfBins) + minValue
    }

    override fun getBinEndValue(bin: Int): Double {
        return (bin + 1) * ((maxValue - minValue) / numberOfBins) + minValue
    }

    override fun isBinnable(value: Value): Boolean {
        return value != null && (value is Number) // || value is java.util.Date)
    }

    override fun valueToBin(value: Value): Int {
//        return if (value != null) {
//            if (value is java.util.Date) {
//                val v: Double = (value as java.util.Date).getTime().toDouble()
//                if (v < minValue) return -1
//                if (v > maxValue) return -2
//                if (v == maxValue) return numberOfBins - 1
//                if (v == minValue) 0 else ((v - minValue) / ((maxValue - minValue) / numberOfBins)).toInt()
//            } else
//                if (value is Number) {
                val v = (value as Number).toDouble()
                if (v < minValue) return -1
                if (v > maxValue) return -2
                if (v == maxValue) return numberOfBins - 1
                if (v == minValue) return 0 else return ((v - minValue) / ((maxValue - minValue) / numberOfBins)).toInt()
//            } else {
//                null
//            }
//        } else {
//            null
//        }
    }
}