/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.subset

import com.macrofocus.common.selection.MutableSelection

/**
 * Created by luc on 11/07/16.
 */
interface SingleBinningDimension<Row, Bin> : BinningDimension<Row, Bin> {
    var binningStrategy: SingleBinningStrategy<Row, Bin>?
    fun getBin(row: Row): Bin
    abstract override val filterExact: MutableSelection<Bin>?
    override fun filterExact(vararg bins: Bin)
    override fun filterExactIterable(bins: Iterable<Bin>)
    interface SingleBinningStrategy<Row, Bin> : BinningDimension.BinningStrategy<Row, Bin> {
        fun rowToBin(row: Row): Bin
    }
}