/*
 * Copyright (c) 2015 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.subset

import com.macrofocus.common.collection.TObjectDoubleMap
import org.molap.series.Series

class SumReducer<Row, Bin>(series: Series<Row, Bin>) : Reducer<Row, Bin> {
    private val series: Series<Row, *>
    override fun add(sums: TObjectDoubleMap<Bin>, bin: Bin, row: Row): Double {
        var sum: Double = sums.getValue(bin)
        val value = getNumber(row)
        if (value != null) {
            sum += value.toDouble()
            sums.put(bin, sum)
        }
        return sum
    }

    override fun remove(sums: TObjectDoubleMap<Bin>, bin: Bin, row: Row): Double {
        var sum: Double = sums.getValue(bin)
        val value = getNumber(row)
        if (value != null) {
            sum -= value.toDouble()
            sums.put(bin, sum)
        }
        return sum
    }

    override fun getNumber(row: Row): Number? {
        val value = series[row]!!
        return if (value is Number) {
            value
        } else {
            null
        }
    }

    init {
        this.series = series
    }
}