package org.molap.dataframe

import com.macrofocus.common.crossplatform.CPHelper
import org.molap.series.doubleSeriesOf
import org.molap.series.seriesOf

class Benchmark {
    val size = 10000

    fun doubleSeriesOf() {
//        val s1 = seriesOf("s1", 1.0, 2.0, 3.0, 4.0)
//        val s1 = randomDoubleSeriesOf("s1", 1000)
        val s1 = doubleSeriesOf("s1", size - 1, {
            (it + 1).toDouble()
        })
        val mean = s1.mean()
        if(mean != size / 2.0) {
            println("Error: " + s1.mean())
        }
    }

    fun seriesOf() {
//        val s1 = seriesOf("s1", 1.0, 2.0, 3.0, null)
//        val s1 = randomSeriesOf("s1", 1000)
        val s1 = seriesOf("s1", size - 1, {
            (it + 1).toDouble()
        })
        val mean = s1.mean()
        if(mean != size / 2.0) {
            println("Error: " + s1.mean())
        }
    }
}

fun main() {
    val benchmark = Benchmark()

    val benchmarks = arrayOf(benchmark::doubleSeriesOf, benchmark::seriesOf)

    benchmarks.forEach { b ->
        val start = CPHelper.instance.currentTimeMillis

        repeat(100000) {
            b.invoke()
        }

        val end = CPHelper.instance.currentTimeMillis
        println("" + b + ": "+ (end - start) + "ms")
    }

}

