package org.molap.exporter

import org.molap.dataframe.DataFrame
import java.io.File
import java.io.FileOutputStream
import java.io.OutputStreamWriter
import java.nio.charset.StandardCharsets

object FileDataFrameExporter {
    fun <R,C,V> exportCSV(dataFrame: DataFrame<R, C, V>, file: File) {
        return exportDelimited(dataFrame, file, ",")
    }

    fun <R,C,V> exportJSon(dataFrame: DataFrame<R, C, V>) : String {
        val newLine = "\n"
        val sb = StringBuilder("\ufeff")
        val output = StringDataFrameOutput(sb)
        val writer: DataFrameWriter = JSONDataFrameWriter(output, newLine)
        DataFrameExporter.export(dataFrame, writer)
        return sb.toString()
    }

    fun <R,C,V> exportJSon(dataFrame: DataFrame<R, C, V>, file: File) {
        val newLine = "\n"
        val output = OutputStreamWriterDataFrameOutput(
            OutputStreamWriter(
                FileOutputStream(file), StandardCharsets.UTF_8
            )
        )
//        output.write("\ufeff")
        val writer: DataFrameWriter = JSONDataFrameWriter(output, newLine)

        DataFrameExporter.export(dataFrame, writer)
    }

    internal fun <R,C,V> exportDelimited(dataFrame: DataFrame<R,C,V>, file: File, delimiter: String) {
        val newLine = "\n"
        val output = OutputStreamWriterDataFrameOutput(
            OutputStreamWriter(
                FileOutputStream(file), StandardCharsets.UTF_8
            )
        )
        output.write("\ufeff")
        val writer: DataFrameWriter = DelimitedDataFrameWriter(output, delimiter, newLine)

        DataFrameExporter.export(dataFrame, writer)
    }
}