/*
 * Copyright (c) 2014 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.aggregates.aggregation

import org.molap.aggregates.cube.Group
import org.molap.aggregates.cuboid.Cuboid
import org.molap.series.Series
import kotlin.reflect.KClass

class VarianceAggregation : AbstractAggregation<Any?> {
    private val column: Series<Any?, Any?>
    private val population: Series<Any?, Any?>?

    constructor(column: Series<Any?, Any?>) {
        this.column = column
        population = null
    }

    constructor(column: Series<Any?, Any?>, population: Series<Any?, Any?>?) {
        this.column = column
        this.population = population
    }

    override val type: KClass<Any>
        get() = Double::class as KClass<Any>

    override fun compute(cuboid: Cuboid?, group: Group?): Any? {
        val d = cuboid!!.getDistributiveStatistics(group, column, null)
        return if (population != null) {
            val p = cuboid.getDistributiveStatistics(group, population, null)
            d!!.uncorrectedSumOfSquares!! / p!!.count - d.mean!! * d.mean!!
        } else {
            d!!.variance
        }
    }

    override fun toString(): String {
        return "Variance(" + column.name + ")"
    }
}