/*
 * Copyright (c) 2014 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.aggregates.cube

import org.molap.aggregates.cuboid.Cuboid
import org.molap.aggregates.query.Structure
import org.molap.dataframe.DataFrame

/**
 * Models a multidimensional dataset, where that data are aggregated across an arbitrary number of dimensions.
 * It can also be seen as a lattice of cuboids.
 */
interface Cube  {
    val dataFrame: DataFrame<Any?,Any?,Any?>
    val apexCuboid: Cuboid?
    val rootGroup: Group?
    val root: Dimensions?
    val dice: Dice?
    val structure: Structure?
    fun getCuboid(dimensions: Dimensions, dice: Dice, structure: Structure): Cuboid?
    fun getChildCuboid(cuboid: Cuboid?): Cuboid?
//    fun query(vararg aggregations: Aggregation?): Query?
//    fun getSum(name: String?): SumAggregation?
//    fun getSum(name: String?, filter: DistributiveStatistics.RowFilter?): SumAggregation?
//    fun getCount(name: String?): CountAggregation?
//    fun getMin(name: String?): MinAggregation?
//    fun getMax(name: String?): MaxAggregation?
//    fun getMean(name: String?): MeanAggregation?
//    fun getVariance(name: String?): VarianceAggregation?
//    fun getVariance(name: String?, population: String?): VarianceAggregation?
//    fun getStdDev(name: String?): StdDevAggregation?
//    fun getCountDistinct(name: String?): CountDistinctAggregation?
//    fun getCountDistinctWithNull(name: String?): CountDistinctWithNullAggregation?
}