package org.molap.convert

import kotlinx.datetime.LocalDateTime
import kotlinx.datetime.format.DateTimeFormat
import kotlinx.datetime.format.Padding
import kotlinx.datetime.format.char
import kotlin.reflect.KClass

class ToDateTimeTypeConverter : TypeConverter {
    val dateFormats: Array<DateTimeFormat<LocalDateTime>> = arrayOf<DateTimeFormat<LocalDateTime>>(
//        DateTimeFormat.getFormat("MM/dd/yyyy"),
//        DateTimeFormat.getFormat("MM/dd/yy"),
//        DateTimeFormat.getFormat("M/d/yyyy"),
//        DateTimeFormat.getFormat("yyyy-MM-dd"),
        // "dd.MM.yyyy HH:mm:ss"
        LocalDateTime.Format {
            dayOfMonth(padding = Padding.ZERO)  // dd
            char('.')                          // .
            monthNumber(padding = Padding.ZERO) // MM
            char('.')                          // .
            year()                             // yyyy
            char(' ')                          // space
            hour(padding = Padding.ZERO)        // HH (24-hour)
            char(':')                          // :
            minute(padding = Padding.ZERO)      // mm
            char(':')                          // :
            second(padding = Padding.ZERO)      // ss
        },
//        DateTimeFormat.getFormat("dd.MM.yyyy"),
//        DateTimeFormat.getFormat("d.M.yyyy"),
    )

    private var dateFormat: DateTimeFormat<LocalDateTime>? = null

    @Throws(IllegalArgumentException::class)
    private fun parse(format: DateTimeFormat<LocalDateTime>, value: String): LocalDateTime? {
        return format.parse(value)
    }

    override fun isConvertable(input: TypeConverter.Input): Boolean {
        if (input.getType() !== LocalDateTime::class) {
            for (format in dateFormats) {
                if (isConvertableToDate(input, format)) {
                    this.dateFormat = format
                    return true
                }
            }
        }
        this.dateFormat = null
        return false
    }

    override fun convert(input: TypeConverter.Input, output: TypeConverter.Output): KClass<*> {
        for (row in 0..<input.size()) {
            val v: Any? = input.get(row)
            if (v != null) {
                if (v is String) {
                    val s = v.trim { it <= ' ' }
                    if (s != "") {
                        var parsed = false
                        try {
                            output.set(row, parse(dateFormat!!, s))
                            parsed = true
                        } catch (e1: IllegalArgumentException) {
                            e1.printStackTrace()
                        }
                        if (!parsed) {
                            output.set(row, null)
                        }
                    } else {
                        output.set(row, null)
                    }
                } else if (v !is LocalDateTime) {
                    output.set(row, null)
                }
            }
        }
        return LocalDateTime::class
    }

    private fun isConvertableToDate(input: TypeConverter.Input, format: DateTimeFormat<LocalDateTime>): Boolean {
        var allNull = true
        for (row in 0..<input.size()) {
            val v: Any? = input.get(row)
            if (v != null) {
                if (v is String) {
                    val s = v.trim { it <= ' ' }
                    if (s != "") {
                        allNull = false
                        var parsed = false
                        try {
                            parse(format, s)
                            parsed = true
                        } catch (e1: IllegalArgumentException) {
                        }
                        if (!parsed) {
                            return false
                        }
                    }
                } else if (v !is LocalDateTime) {
                    return false
                }
            }
        }
        return !allNull
    }

    override val type: KClass<*>
        get() = LocalDateTime::class
}
