/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.convert

import kotlin.reflect.KClass

class ToDoubleTypeConverter : TypeConverter {
    override fun isConvertable(input: TypeConverter.Input): Boolean {
        if (input.getType() != Double::class) {
            var allNull = true
            for (row in 0..<input.size()) {
                val v: Any? = input.get(row)
                if (v != null) {
                    if (v is String) {
                        val s = v.trim { it <= ' ' }
                        if (s != "") {
                            allNull = false
                            try {
                                s.toDouble()
                            } catch (e: NumberFormatException) {
                                val parsed = false
                                if (!parsed) {
                                    return false
                                }
                            }
                        }
                    } else if (v !is Double) {
                        return false
                    }
                }
            }
            return !allNull
        } else {
            return false
        }
    }

    override fun convert(input: TypeConverter.Input, output: TypeConverter.Output): KClass<*> {
        for (row in 0..<input.size()) {
            val v: Any? = input.get(row)
            if (v != null) {
                if (v is String) {
                    val s = v.trim { it <= ' ' }
                    if (s != "") {
                        try {
                            output.set(row, s.toDouble())
                        } catch (e: NumberFormatException) {
                            val parsed = false
                            if (!parsed) {
                                output.set(row, null)
                            }
                        }
                    } else {
                        output.set(row, null)
                    }
                } else if (v !is Double) {
                    output.set(row, null)
                }
            }
        }
        return Double::class
    }

    override val type: KClass<*>
        get() = Double::class
}
