package org.molap.convert

import kotlinx.datetime.*
import kotlin.reflect.KClass

class ToInstantTypeConverter : TypeConverter {
    override fun isConvertable(input: TypeConverter.Input): Boolean {
        return input.getType() == LocalDateTime::class || input.getType() == LocalDate::class
//                || input.getType() == kotlin.time.Instant::class
    }

    override fun convert(input: TypeConverter.Input, output: TypeConverter.Output): KClass<*> {
        for (row in 0..<input.size()) {
            val v: Any? = input.get(row)
            if (v != null) {
                if (v is LocalDateTime) {
                    output.set(row, v.toInstant(TimeZone.UTC))
                } else if(v is LocalDate) {
                    output.set(row, v.atStartOfDayIn(TimeZone.UTC))
//                } else if(v is kotlin.time.Instant) {
//                    output.set(row, Instant.fromEpochMilliseconds(v.toEpochMilliseconds(TimeZone.UTC)))
                } else if (v is Instant) {
                    output.set(row, v)
                } else {
                    output.set(row, null)
                }
            }
        }
        return Instant::class
    }

    override val type: KClass<*>
        get() = Instant::class
}
