/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.convert

import kotlin.reflect.KClass

interface TypeConverter {
    fun isConvertable(input: Input): Boolean

    fun convert(input: Input, output: Output): KClass<*>?

    val type: KClass<*>

    interface Input {
        fun getType(): KClass<*>

        fun get(index: Int): Any?

        fun size(): Int
    }

    interface Output {
        fun setType(type: KClass<*>?)

        fun set(index: Int, value: Any?)
    }
}
