package org.molap.csv

import kotlinx.io.Sink
import org.molap.dataframe.DataFrame
import org.molap.exporter.DataFrameExporter
import org.molap.exporter.DelimitedDataFrameWriter
import org.molap.exporter.SinkDataFrameOutput

fun <R,C,V> DataFrame<R, C, V>.writeCSV(sink: Sink) {
    val delimiter = ","
    val newLine = "\n"
    DataFrameExporter.export(this, DelimitedDataFrameWriter(SinkDataFrameOutput(sink), delimiter, newLine))
    sink.flush()
}
