package org.molap.dataframe

import org.molap.index.MultiKey

/**
 * Defines the requirements for a data frame that can change.
 */
interface MutableDataFrame<R, C, V> : DataFrame<R, C, V> {
    /**
     * Sets the value for the cell at the intersection of the
     * `column` key and `row` key.
     *
     * @param   row        the row key whose value is to be changed
     * @param   column     the column key whose value is to be changed
     * @param value the new value at the specified cell
     */
    fun setValueAt(row: R, column: C, value: V)

    /**
     * Returns a new data frame reindexed using the values coming from the specified column.
     *
     * @param column the column to use for the label values
     * @return the reindexed data frame.
     */
    fun reindexRowsUsingColumn(column: C): MutableDataFrame<V, C, V>?

    /**
     * Returns a new data frame reindexed using the values coming from the specified columns.
     *
     * @param rows the columns to use for the label values
     * @return the reindexed data frame.
     */
    fun reindexRowsUsingColumns(vararg rows: C): MutableDataFrame<MultiKey?, C, V>?
}
