package org.molap.network

data class AdjacencyList<V, out L>(val entries: List<Entry<V, L>>) {
    constructor(vararg entries: Entry<V, L>): this(entries.asList())
    override fun toString() = "AdjacencyList(${entries.joinToString()})"

    data class Entry<out V, out L>(val node: V, val links: List<Link<V, L>> = emptyList<Nothing>()) {
        constructor(node: V, vararg links: Link<V, L>): this(node, links.asList())
        override fun toString() = "Entry($node, links[${links.joinToString()}])"
        companion object {
            fun <V> links(vararg linkValues: V): List<Link<V, Nothing>> = linkValues.map { Link(it, null) }
        }
    }

    data class Link<out V, out L>(val node: V, val label: L? = null) {
        override fun toString() = if (label == null) "$node" else "$node/$label"
    }
}