package org.molap.series

import org.molap.index.IntegerRangeUniqueIndex
import org.molap.index.UniqueIndex
import kotlin.reflect.KClass

class FloatSeries : AbstractSeries<Int, Float?>, MutableSeries<Int, Float?> {
    override val name: Any?
    private val available: BooleanArray?
    private val values: FloatArray
    private val index: UniqueIndex<Int>

    constructor(values: FloatArray) {
        name = null
        this.values = values
        index = IntegerRangeUniqueIndex(0, values.size - 1)
        available = null
    }

    constructor(name: Any?, values: FloatArray) {
        this.name = name
        this.values = values
        index = IntegerRangeUniqueIndex(0, values.size - 1)
        available = null
    }

    constructor(values: FloatArray, available: BooleanArray?) {
        name = null
        this.values = values
        index = IntegerRangeUniqueIndex(0, values.size - 1)
        this.available = available
    }

    private constructor(values: FloatArray, index: UniqueIndex<Int>) {
        name = null
        this.values = values
        this.index = index
        available = null
    }

    override val type: KClass<Any>
        get() = Float::class as KClass<Any>

    override operator fun get(key: Int): Float? {
        return if (isNull(key)) null as Float? else values[key]
    }

    fun isNull(key: Int): Boolean {
        return available != null && !available[key]
    }

    fun getDouble(key: Int): Double {
        return values[key].toDouble()
    }

    override fun getKey(i: Int): Int {
        return index.getKey(i)
    }

    override fun size(): Int {
        return index.size
    }

    override fun getAddress(key: Int): Int {
        return index.getAddress(key)
    }

    override operator fun set(key: Int, value: Float?) {
        if(value != null) {
            values[key] = value
            if(available != null) {
                available[key] = true
            } else {
                // ToDo: Exception?
            }
        } else {
            if(available != null) {
                available[key] = false
            } else {
                // ToDo: Exception?
            }
        }
    }

    override fun keys(): Iterable<Int> {
        return index.keys()
    }

    fun <L> reindex(vararg keys: L): Series<L, Float>? {
        return null
    }

    fun head(count: Int): Series<Int, Float>? {
        return reindex(index.head(count))
    }

    fun tail(count: Int): Series<Int, Float>? {
        return reindex(index.tail(count))
    }

    fun <K> reindex(index: UniqueIndex<K>?): Series<K, Float>? {
//        return new IndexedSeries<K,Double>(getName(), values, index);
        return null
    }
}
